/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read;

import java.io.File;
import java.io.IOException;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRestorableReader
extends TsFileSequenceReader {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRestorableReader.class);

    public TsFileRestorableReader(String file) throws IOException {
        this(file, true);
    }

    public TsFileRestorableReader(String file, boolean autoRepair) throws IOException {
        super(file, !autoRepair);
        if (autoRepair) {
            try {
                this.checkAndRepair();
            }
            catch (Throwable e) {
                this.close();
                throw e;
            }
            this.loadMetadataSize();
        }
    }

    private void checkAndRepair() throws IOException {
        if (!this.isComplete()) {
            logger.info("File {} has no correct tail magic, try to repair...", (Object)this.file);
            RestorableTsFileIOWriter rWriter = new RestorableTsFileIOWriter(new File(this.file));
            TsFileWriter writer = new TsFileWriter(rWriter);
            writer.close();
        }
    }
}

