/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class TsFileMetaData {
    private Map<String, TsDeviceMetadataIndex> deviceIndexMap = new HashMap<String, TsDeviceMetadataIndex>();
    private Map<String, MeasurementSchema> measurementSchema = new HashMap<String, MeasurementSchema>();
    private int currentVersion;
    private String createdBy;

    public TsFileMetaData() {
    }

    public TsFileMetaData(Map<String, TsDeviceMetadataIndex> deviceMap, Map<String, MeasurementSchema> measurementSchema, int currentVersion) {
        this.deviceIndexMap = deviceMap;
        this.measurementSchema = measurementSchema;
        this.currentVersion = currentVersion;
    }

    public static TsFileMetaData deserializeFrom(InputStream inputStream) throws IOException {
        TsFileMetaData fileMetaData = new TsFileMetaData();
        int size = ReadWriteIOUtils.readInt(inputStream);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndex> deviceMap = new HashMap<String, TsDeviceMetadataIndex>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                TsDeviceMetadataIndex value = TsDeviceMetadataIndex.deserializeFrom(inputStream);
                deviceMap.put(key, value);
            }
            fileMetaData.deviceIndexMap = deviceMap;
        }
        if ((size = ReadWriteIOUtils.readInt(inputStream)) > 0) {
            fileMetaData.measurementSchema = new HashMap<String, MeasurementSchema>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(inputStream);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(inputStream);
                fileMetaData.measurementSchema.put(key, value);
            }
        }
        fileMetaData.currentVersion = ReadWriteIOUtils.readInt(inputStream);
        if (ReadWriteIOUtils.readIsNull(inputStream)) {
            fileMetaData.createdBy = ReadWriteIOUtils.readString(inputStream);
        }
        return fileMetaData;
    }

    public static TsFileMetaData deserializeFrom(ByteBuffer buffer) throws IOException {
        TsFileMetaData fileMetaData = new TsFileMetaData();
        int size = ReadWriteIOUtils.readInt(buffer);
        if (size > 0) {
            HashMap<String, TsDeviceMetadataIndex> deviceMap = new HashMap<String, TsDeviceMetadataIndex>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                TsDeviceMetadataIndex value = TsDeviceMetadataIndex.deserializeFrom(buffer);
                deviceMap.put(key, value);
            }
            fileMetaData.deviceIndexMap = deviceMap;
        }
        if ((size = ReadWriteIOUtils.readInt(buffer)) > 0) {
            fileMetaData.measurementSchema = new HashMap<String, MeasurementSchema>();
            for (int i = 0; i < size; ++i) {
                String key = ReadWriteIOUtils.readString(buffer);
                MeasurementSchema value = MeasurementSchema.deserializeFrom(buffer);
                fileMetaData.measurementSchema.put(key, value);
            }
        }
        fileMetaData.currentVersion = ReadWriteIOUtils.readInt(buffer);
        if (ReadWriteIOUtils.readIsNull(buffer)) {
            fileMetaData.createdBy = ReadWriteIOUtils.readString(buffer);
        }
        return fileMetaData;
    }

    public void addMeasurementSchema(MeasurementSchema measurementSchema) {
        this.measurementSchema.put(measurementSchema.getMeasurementId(), measurementSchema);
    }

    public String toString() {
        return "TsFileMetaData{deviceIndexMap=" + this.deviceIndexMap + ", measurementSchema=" + this.measurementSchema + ", CURRENT_VERSION=" + this.currentVersion + ", createdBy='" + this.createdBy + '\'' + '}';
    }

    public int getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(int currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Map<String, TsDeviceMetadataIndex> getDeviceMap() {
        return this.deviceIndexMap;
    }

    public void setDeviceMap(Map<String, TsDeviceMetadataIndex> deviceMap) {
        this.deviceIndexMap = deviceMap;
    }

    public boolean containsDevice(String deltaObjUid) {
        return this.deviceIndexMap.containsKey(deltaObjUid);
    }

    public TsDeviceMetadataIndex getDeviceMetadataIndex(String deltaObjUid) {
        return this.deviceIndexMap.get(deltaObjUid);
    }

    public boolean containsMeasurement(String measurement) {
        return this.measurementSchema.containsKey(measurement);
    }

    public TSDataType getType(String measurement) {
        if (this.containsMeasurement(measurement)) {
            return this.measurementSchema.get(measurement).getType();
        }
        return null;
    }

    public Map<String, MeasurementSchema> getMeasurementSchema() {
        return this.measurementSchema;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceIndexMap.size(), outputStream);
        for (Map.Entry<String, TsDeviceMetadataIndex> entry : this.deviceIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
            byteLen += entry.getValue().serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.measurementSchema.size(), outputStream);
        for (Map.Entry<String, Object> entry : this.measurementSchema.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), outputStream);
            byteLen += ((MeasurementSchema)entry.getValue()).serializeTo(outputStream);
        }
        byteLen += ReadWriteIOUtils.write(this.currentVersion, outputStream);
        byteLen += ReadWriteIOUtils.writeIsNull((Object)this.createdBy, outputStream);
        if (this.createdBy != null) {
            byteLen += ReadWriteIOUtils.write(this.createdBy, outputStream);
        }
        return byteLen;
    }

    public int serializeTo(ByteBuffer buffer) throws IOException {
        int byteLen = 0;
        byteLen += ReadWriteIOUtils.write(this.deviceIndexMap.size(), buffer);
        for (Map.Entry<String, TsDeviceMetadataIndex> entry : this.deviceIndexMap.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
            byteLen += entry.getValue().serializeTo(buffer);
        }
        byteLen += ReadWriteIOUtils.write(this.measurementSchema.size(), buffer);
        for (Map.Entry<String, Object> entry : this.measurementSchema.entrySet()) {
            byteLen += ReadWriteIOUtils.write(entry.getKey(), buffer);
            byteLen += ((MeasurementSchema)entry.getValue()).serializeTo(buffer);
        }
        byteLen += ReadWriteIOUtils.write(this.currentVersion, buffer);
        byteLen += ReadWriteIOUtils.writeIsNull((Object)this.createdBy, buffer);
        if (this.createdBy != null) {
            byteLen += ReadWriteIOUtils.write(this.createdBy, buffer);
        }
        return byteLen;
    }
}

