/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkHeader {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkHeader.class);
    public static final byte MARKER = 1;
    private String measurementID;
    private int dataSize;
    private TSDataType dataType;
    private CompressionType compressionType;
    private TSEncoding encodingType;
    private int numOfPages;
    private long maxTombstoneTime;
    private int serializedSize;

    public ChunkHeader(String measurementID, int dataSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding, int numOfPages) {
        this(measurementID, dataSize, dataType, compressionType, encoding, numOfPages, 0L);
    }

    private ChunkHeader(String measurementID, int dataSize, TSDataType dataType, CompressionType compressionType, TSEncoding encoding, int numOfPages, long maxTombstoneTime) {
        this.measurementID = measurementID;
        this.dataSize = dataSize;
        this.dataType = dataType;
        this.compressionType = compressionType;
        this.numOfPages = numOfPages;
        this.encodingType = encoding;
        this.serializedSize = ChunkHeader.getSerializedSize(measurementID);
        this.maxTombstoneTime = maxTombstoneTime;
    }

    public static int getSerializedSize(String measurementID) {
        try {
            return 5 + ChunkHeader.getSerializedSize(measurementID.getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("{} encoding is not supported", (Object)"UTF-8");
            return 5 + ChunkHeader.getSerializedSize(measurementID.getBytes().length);
        }
    }

    private static int getSerializedSize(int measurementIdLength) {
        return measurementIdLength + 4 + TSDataType.getSerializedSize() + 4 + CompressionType.getSerializedSize() + TSEncoding.getSerializedSize() + 8;
    }

    public static ChunkHeader deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 1) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String measurementID = ReadWriteIOUtils.readString(inputStream);
        int dataSize = ReadWriteIOUtils.readInt(inputStream);
        TSDataType dataType = TSDataType.deserialize(ReadWriteIOUtils.readShort(inputStream));
        int numOfPages = ReadWriteIOUtils.readInt(inputStream);
        CompressionType type = ReadWriteIOUtils.readCompressionType(inputStream);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(inputStream);
        long maxTombstoneTime = ReadWriteIOUtils.readLong(inputStream);
        return new ChunkHeader(measurementID, dataSize, dataType, type, encoding, numOfPages, maxTombstoneTime);
    }

    public static ChunkHeader deserializeFrom(ByteBuffer byteBuffer, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = byteBuffer.get()) != 1) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String measurementID = ReadWriteIOUtils.readString(byteBuffer);
        return ChunkHeader.deserializePartFrom(measurementID, byteBuffer);
    }

    public static ChunkHeader deserializeFrom(TsFileInput input, long offset, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        ByteBuffer buffer = ByteBuffer.allocate(4);
        input.read(buffer, offsetVar);
        buffer.flip();
        int size = buffer.getInt();
        buffer = ByteBuffer.allocate(ChunkHeader.getSerializedSize(size));
        ReadWriteIOUtils.readAsPossible(input, offsetVar += 4L, buffer);
        buffer.flip();
        String measurementID = ReadWriteIOUtils.readStringWithoutLength(buffer, size);
        return ChunkHeader.deserializePartFrom(measurementID, buffer);
    }

    private static ChunkHeader deserializePartFrom(String measurementID, ByteBuffer buffer) throws UnsupportedEncodingException {
        int dataSize = ReadWriteIOUtils.readInt(buffer);
        TSDataType dataType = TSDataType.deserialize(ReadWriteIOUtils.readShort(buffer));
        int numOfPages = ReadWriteIOUtils.readInt(buffer);
        CompressionType type = ReadWriteIOUtils.readCompressionType(buffer);
        TSEncoding encoding = ReadWriteIOUtils.readEncoding(buffer);
        long maxTombstoneTime = ReadWriteIOUtils.readLong(buffer);
        return new ChunkHeader(measurementID, dataSize, dataType, type, encoding, numOfPages, maxTombstoneTime);
    }

    public int getSerializedSize() {
        return this.serializedSize;
    }

    public String getMeasurementID() {
        return this.measurementID;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public int serializeTo(OutputStream outputStream) throws IOException {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)1, outputStream);
        length += ReadWriteIOUtils.write(this.measurementID, outputStream);
        length += ReadWriteIOUtils.write(this.dataSize, outputStream);
        length += ReadWriteIOUtils.write(this.dataType, outputStream);
        length += ReadWriteIOUtils.write(this.numOfPages, outputStream);
        length += ReadWriteIOUtils.write(this.compressionType, outputStream);
        length += ReadWriteIOUtils.write(this.encodingType, outputStream);
        return length += ReadWriteIOUtils.write(this.maxTombstoneTime, outputStream);
    }

    public int serializeTo(ByteBuffer buffer) {
        int length = 0;
        length += ReadWriteIOUtils.write((byte)1, buffer);
        length += ReadWriteIOUtils.write(this.measurementID, buffer);
        length += ReadWriteIOUtils.write(this.dataSize, buffer);
        length += ReadWriteIOUtils.write(this.dataType, buffer);
        length += ReadWriteIOUtils.write(this.numOfPages, buffer);
        length += ReadWriteIOUtils.write(this.compressionType, buffer);
        length += ReadWriteIOUtils.write(this.encodingType, buffer);
        return length += ReadWriteIOUtils.write(this.maxTombstoneTime, buffer);
    }

    public int getNumOfPages() {
        return this.numOfPages;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public TSEncoding getEncodingType() {
        return this.encodingType;
    }

    public long getMaxTombstoneTime() {
        return this.maxTombstoneTime;
    }

    public void setMaxTombstoneTime(long maxTombstoneTime) {
        this.maxTombstoneTime = maxTombstoneTime;
    }

    public String toString() {
        return "CHUNK_HEADER{measurementID='" + this.measurementID + '\'' + ", dataSize=" + this.dataSize + ", dataType=" + (Object)((Object)this.dataType) + ", compressionType=" + (Object)((Object)this.compressionType) + ", encodingType=" + (Object)((Object)this.encodingType) + ", numOfPages=" + this.numOfPages + ", serializedSize=" + this.serializedSize + '}';
    }
}

