/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import org.apache.iotdb.tsfile.encoding.encoder.Encoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public abstract class GorillaEncoder
extends Encoder {
    protected boolean flag = false;
    protected int leadingZeroNum;
    protected int tailingZeroNum;
    protected byte buffer;
    protected int numberLeftInBuffer;

    public GorillaEncoder() {
        super(TSEncoding.GORILLA);
    }

    protected void writeBit(boolean b, ByteArrayOutputStream out) {
        this.buffer = (byte)(this.buffer << 1);
        if (b) {
            this.buffer = (byte)(this.buffer | 1);
        }
        ++this.numberLeftInBuffer;
        if (this.numberLeftInBuffer == 8) {
            this.clearBuffer(out);
        }
    }

    protected void writeBit(int i, ByteArrayOutputStream out) {
        if (i == 0) {
            this.writeBit(false, out);
        } else {
            this.writeBit(true, out);
        }
    }

    protected void writeBit(long i, ByteArrayOutputStream out) {
        if (i == 0L) {
            this.writeBit(false, out);
        } else {
            this.writeBit(true, out);
        }
    }

    protected void clearBuffer(ByteArrayOutputStream out) {
        if (this.numberLeftInBuffer == 0) {
            return;
        }
        if (this.numberLeftInBuffer > 0) {
            this.buffer = (byte)(this.buffer << 8 - this.numberLeftInBuffer);
        }
        out.write(this.buffer);
        this.numberLeftInBuffer = 0;
        this.buffer = 0;
    }

    protected void reset() {
        this.flag = false;
        this.numberLeftInBuffer = 0;
        this.buffer = 0;
    }
}

