/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.writelog.io.ILogWriter;

public class LogWriter
implements ILogWriter {
    private File logFile;
    private FileOutputStream fileOutputStream;
    private FileChannel channel;
    private CRC32 checkSummer = new CRC32();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
    private ByteBuffer checkSumBuffer = ByteBuffer.allocate(8);

    public LogWriter(String logFilePath) {
        this.logFile = new File(logFilePath);
    }

    public LogWriter(File logFile) {
        this.logFile = logFile;
    }

    @Override
    public void write(ByteBuffer logBuffer) throws IOException {
        if (this.channel == null) {
            this.fileOutputStream = new FileOutputStream(this.logFile, true);
            this.channel = this.fileOutputStream.getChannel();
        }
        logBuffer.flip();
        int logSize = logBuffer.limit();
        this.checkSummer.reset();
        this.checkSummer.update(logBuffer);
        long checkSum = this.checkSummer.getValue();
        logBuffer.flip();
        this.lengthBuffer.clear();
        this.checkSumBuffer.clear();
        this.lengthBuffer.putInt(logSize);
        this.checkSumBuffer.putLong(checkSum);
        this.lengthBuffer.flip();
        this.checkSumBuffer.flip();
        this.channel.write(this.lengthBuffer);
        this.channel.write(logBuffer);
        this.channel.write(this.checkSumBuffer);
        if (this.config.getForceWalPeriodInMs() == 0L) {
            this.channel.force(true);
        }
    }

    @Override
    public void force() throws IOException {
        if (this.channel != null) {
            this.channel.force(true);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.fileOutputStream.close();
            this.fileOutputStream = null;
            this.channel.close();
            this.channel = null;
        }
    }
}

