/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.Serializable;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class TsPrimitiveType
implements Serializable {
    public static TsPrimitiveType getByType(TSDataType dataType, Object v) {
        switch (dataType) {
            case BOOLEAN: {
                return new TsBoolean((Boolean)v);
            }
            case INT32: {
                return new TsInt((Integer)v);
            }
            case INT64: {
                return new TsLong((Long)v);
            }
            case FLOAT: {
                return new TsFloat(((Float)v).floatValue());
            }
            case DOUBLE: {
                return new TsDouble((Double)v);
            }
            case TEXT: {
                return new TsBinary((Binary)v);
            }
        }
        throw new UnSupportedDataTypeException("Unsupported data type:" + dataType);
    }

    public boolean getBoolean() {
        throw new UnsupportedOperationException("getBoolean() is not supported for current sub-class");
    }

    public int getInt() {
        throw new UnsupportedOperationException("getInt() is not supported for current sub-class");
    }

    public long getLong() {
        throw new UnsupportedOperationException("getLong() is not supported for current sub-class");
    }

    public float getFloat() {
        throw new UnsupportedOperationException("getFloat() is not supported for current sub-class");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("getDouble() is not supported for current sub-class");
    }

    public Binary getBinary() {
        throw new UnsupportedOperationException("getBinary() is not supported for current sub-class");
    }

    public abstract int getSize();

    public abstract Object getValue();

    public abstract String getStringValue();

    public abstract TSDataType getDataType();

    public String toString() {
        return this.getStringValue();
    }

    public boolean equals(Object object) {
        return object instanceof TsPrimitiveType && ((TsPrimitiveType)object).getValue().equals(this.getValue());
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public static class TsBinary
    extends TsPrimitiveType {
        private Binary value;

        public TsBinary(Binary value) {
            this.value = value;
        }

        @Override
        public Binary getBinary() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 8 + this.value.getLength();
        }

        @Override
        public Object getValue() {
            return this.getBinary();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.TEXT;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsBinary) {
                TsBinary anotherTs = (TsBinary)anObject;
                return this.value.equals((Object)anotherTs.value);
            }
            return false;
        }
    }

    public static class TsDouble
    extends TsPrimitiveType {
        private double value;

        public TsDouble(double value) {
            this.value = value;
        }

        @Override
        public double getDouble() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public Object getValue() {
            return this.getDouble();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.DOUBLE;
        }

        @Override
        public int hashCode() {
            return Double.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsDouble) {
                TsDouble anotherTs = (TsDouble)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsFloat
    extends TsPrimitiveType {
        private float value;

        public TsFloat(float value) {
            this.value = value;
        }

        @Override
        public float getFloat() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.getFloat());
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.FLOAT;
        }

        @Override
        public int hashCode() {
            return Float.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsFloat) {
                TsFloat anotherTs = (TsFloat)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsLong
    extends TsPrimitiveType {
        private long value;

        public TsLong(long value) {
            this.value = value;
        }

        @Override
        public long getLong() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 12;
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.INT64;
        }

        @Override
        public Object getValue() {
            return this.getLong();
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsLong) {
                TsLong anotherTs = (TsLong)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsInt
    extends TsPrimitiveType {
        private int value;

        public TsInt(int value) {
            this.value = value;
        }

        @Override
        public int getInt() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 8;
        }

        @Override
        public Object getValue() {
            return this.getInt();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.INT32;
        }

        @Override
        public int hashCode() {
            return Integer.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsInt) {
                TsInt anotherTs = (TsInt)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }

    public static class TsBoolean
    extends TsPrimitiveType {
        private boolean value;

        public TsBoolean(boolean value) {
            this.value = value;
        }

        @Override
        public boolean getBoolean() {
            return this.value;
        }

        @Override
        public int getSize() {
            return 5;
        }

        @Override
        public Object getValue() {
            return this.getBoolean();
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.BOOLEAN;
        }

        @Override
        public int hashCode() {
            return Boolean.hashCode(this.value);
        }

        @Override
        public boolean equals(Object anObject) {
            if (this == anObject) {
                return true;
            }
            if (anObject instanceof TsBoolean) {
                TsBoolean anotherTs = (TsBoolean)anObject;
                return this.value == anotherTs.value;
            }
            return false;
        }
    }
}

