/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.BooleanDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.FloatDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.IntDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.StringDataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemUtils {
    private static Logger logger = LoggerFactory.getLogger(MemUtils.class);

    private MemUtils() {
    }

    public static long getRecordSize(InsertPlan insertPlan) {
        long memSize = 0L;
        block8: for (int i = 0; i < insertPlan.getValues().length; ++i) {
            switch (insertPlan.getDataTypes()[i]) {
                case INT32: {
                    memSize += 12L;
                    continue block8;
                }
                case INT64: {
                    memSize += 16L;
                    continue block8;
                }
                case FLOAT: {
                    memSize += 12L;
                    continue block8;
                }
                case DOUBLE: {
                    memSize += 16L;
                    continue block8;
                }
                case BOOLEAN: {
                    memSize += 9L;
                    continue block8;
                }
                case TEXT: {
                    memSize += 8L + (long)(insertPlan.getValues()[i].length() * 2);
                    continue block8;
                }
                default: {
                    memSize += 16L;
                }
            }
        }
        return memSize;
    }

    public static long getTsRecordMem(TSRecord record) {
        long memUsed = 8L;
        memUsed += 8L;
        memUsed += MemUtils.getStringMem(record.deviceId);
        for (DataPoint dataPoint : record.dataPointList) {
            memUsed += 8L;
            memUsed += MemUtils.getDataPointMem(dataPoint);
        }
        return memUsed;
    }

    public static long getStringMem(String str) {
        return (long)(str.length() * 2) + 64L;
    }

    public static long getDataPointMem(DataPoint dataPoint) {
        long memUsed = 8L;
        memUsed += MemUtils.getStringMem(dataPoint.getMeasurementId());
        memUsed += 8L;
        if (dataPoint instanceof FloatDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof IntDataPoint) {
            memUsed += 4L;
        } else if (dataPoint instanceof BooleanDataPoint) {
            ++memUsed;
        } else if (dataPoint instanceof DoubleDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof LongDataPoint) {
            memUsed += 8L;
        } else if (dataPoint instanceof StringDataPoint) {
            StringDataPoint stringDataPoint = (StringDataPoint)dataPoint;
            memUsed += 28L;
            memUsed += (long)((Binary)stringDataPoint.getValue()).getLength();
            memUsed += 8L;
            memUsed += MemUtils.getStringMem(((Binary)stringDataPoint.getValue()).getTextEncodingType());
        } else {
            logger.error("Unsupported data point type");
        }
        return memUsed;
    }

    public static String bytesCntToStr(long inputCnt) {
        long cnt = inputCnt;
        long gbs = cnt / 0x40000000L;
        long mbs = (cnt %= 0x40000000L) / 0x100000L;
        long kbs = (cnt %= 0x100000L) / 1024L;
        return gbs + " GB " + mbs + " MB " + kbs + " KB " + (cnt %= 1024L) + " B";
    }
}

