/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.receiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.executor.QueryProcessExecutor;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.db.utils.SyncUtils;
import org.apache.iotdb.service.sync.thrift.SyncDataStatus;
import org.apache.iotdb.service.sync.thrift.SyncService;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.ReadOnlyTsFile;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncServiceImpl
implements SyncService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(SyncServiceImpl.class);
    private static final StorageEngine STORAGE_GROUP_MANAGER = StorageEngine.getInstance();
    private static final MManager metadataManger = MManager.getInstance();
    private static final String SYNC_SERVER = "sync-server";
    private ThreadLocal<String> uuid = new ThreadLocal();
    private ThreadLocal<Map<String, List<String>>> fileNodeMap = new ThreadLocal();
    private ThreadLocal<Map<String, Map<String, Long>>> fileNodeStartTime = new ThreadLocal();
    private ThreadLocal<Map<String, Map<String, Long>>> fileNodeEndTime = new ThreadLocal();
    private ThreadLocal<Integer> fileNum = new ThreadLocal();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private String baseDir = this.config.getBaseDir();
    private String[] bufferWritePaths = this.config.getDataDirs();
    private ThreadLocal<String> schemaFromSenderPath = new ThreadLocal();
    private String syncFolderPath;
    private String syncDataPath;

    public boolean init(String storageGroup) {
        logger.info("Sync process starts to receive data of storage group {}", (Object)storageGroup);
        this.fileNum.set(0);
        this.fileNodeMap.set(new HashMap());
        this.fileNodeStartTime.set(new HashMap());
        this.fileNodeEndTime.set(new HashMap());
        try {
            FileUtils.deleteDirectory((File)new File(this.syncDataPath));
        }
        catch (IOException e) {
            logger.error("cannot delete directory {} ", (Object)this.syncFolderPath);
            return false;
        }
        for (String bufferWritePath : this.bufferWritePaths) {
            String backupPath = (bufferWritePath = FilePathUtils.regularizePath(bufferWritePath)) + SYNC_SERVER + File.separator;
            File backupDirectory = new File(backupPath, this.uuid.get());
            if (!backupDirectory.exists() || backupDirectory.list().length == 0) continue;
            try {
                FileUtils.deleteDirectory((File)backupDirectory);
            }
            catch (IOException e) {
                logger.error("cannot delete directory {} ", (Object)this.syncFolderPath);
                return false;
            }
        }
        return true;
    }

    public boolean checkIdentity(String uuid, String ipAddress) {
        Thread.currentThread().setName(ThreadName.SYNC_SERVER.getName());
        this.uuid.set(uuid);
        this.initPath();
        return SyncUtils.verifyIPSegment(this.config.getIpWhiteList(), ipAddress);
    }

    private void initPath() {
        this.baseDir = FilePathUtils.regularizePath(this.baseDir);
        this.syncFolderPath = this.baseDir + SYNC_SERVER + File.separatorChar + this.uuid.get();
        this.syncDataPath = this.syncFolderPath + File.separatorChar + "data-snapshot";
        this.schemaFromSenderPath.set(this.syncFolderPath + File.separator + "mlog.txt");
    }

    public String syncSchema(String md5, ByteBuffer schema, SyncDataStatus status) {
        String md5OfReceiver = Boolean.toString(Boolean.TRUE);
        if (status == SyncDataStatus.SUCCESS_STATUS) {
            return Boolean.toString(this.loadMetadata());
        }
        if (status == SyncDataStatus.PROCESSING_STATUS) {
            File file = new File(this.schemaFromSenderPath.get());
            if (!file.getParentFile().exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.error("Cannot make schema file {}.", (Object)file.getPath(), (Object)e);
                    md5OfReceiver = Boolean.toString(Boolean.FALSE);
                }
            }
            try (FileOutputStream fos = new FileOutputStream(file, true);
                 FileChannel channel = fos.getChannel();){
                channel.write(schema);
            }
            catch (Exception e) {
                logger.error("Cannot insert data to file {}.", (Object)file.getPath(), (Object)e);
                md5OfReceiver = Boolean.toString(Boolean.FALSE);
            }
        } else {
            try (FileInputStream fis = new FileInputStream(this.schemaFromSenderPath.get());){
                int n;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[0x4000000];
                while ((n = fis.read(buffer)) != -1) {
                    md.update(buffer, 0, n);
                }
                md5OfReceiver = new BigInteger(1, md.digest()).toString(16);
                if (!md5.equals(md5OfReceiver)) {
                    FileUtils.forceDelete((File)new File(this.schemaFromSenderPath.get()));
                }
            }
            catch (Exception e) {
                logger.error("Receiver cannot generate md5 {}", (Object)this.schemaFromSenderPath.get(), (Object)e);
            }
        }
        return md5OfReceiver;
    }

    private boolean loadMetadata() {
        if (new File(this.schemaFromSenderPath.get()).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(this.schemaFromSenderPath.get()));){
                String metadataOperation;
                while ((metadataOperation = br.readLine()) != null) {
                    this.operation(metadataOperation);
                }
            }
            catch (FileNotFoundException e) {
                logger.error("Cannot read the file {}.", (Object)this.schemaFromSenderPath.get(), (Object)e);
                return false;
            }
            catch (IOException e) {
            }
            catch (Exception e) {
                logger.error("Parse metadata operation failed.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private void operation(String cmd) throws PathErrorException, IOException, MetadataErrorException {
        String[] args = cmd.trim().split(",");
        switch (args[0]) {
            case "0": {
                HashMap<String, String> props = new HashMap<String, String>(args.length - 5 + 1, 1.0f);
                for (int k = 5; k < args.length; ++k) {
                    String[] kv = args[k].split("=");
                    props.put(kv[0], kv[1]);
                }
                metadataManger.addPathToMTree(new Path(args[1]), TSDataType.deserialize((short)Short.valueOf(args[2])), TSEncoding.deserialize((short)Short.valueOf(args[3])), CompressionType.deserialize((short)Short.valueOf(args[4])), props);
                break;
            }
            case "1": {
                metadataManger.deletePaths(Collections.singletonList(new Path(args[1])));
                break;
            }
            case "2": {
                metadataManger.setStorageLevelToMTree(args[1]);
                break;
            }
            case "3": {
                metadataManger.addAPTree(args[1]);
                break;
            }
            case "4": {
                metadataManger.addPathToPTree(args[1]);
                break;
            }
            case "5": {
                metadataManger.deletePathFromPTree(args[1]);
                break;
            }
            case "6": {
                metadataManger.linkMNodeToPTree(args[1], args[2]);
                break;
            }
            case "7": {
                metadataManger.unlinkMNodeFromPTree(args[1], args[2]);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)cmd);
            }
        }
    }

    public String syncData(String md5OfSender, List<String> filePathSplit, ByteBuffer dataToReceive, SyncDataStatus status) {
        String md5OfReceiver = Boolean.toString(Boolean.TRUE);
        String filePath = StringUtils.join(filePathSplit, (char)File.separatorChar);
        this.syncDataPath = FilePathUtils.regularizePath(this.syncDataPath);
        filePath = this.syncDataPath + filePath;
        if (status == SyncDataStatus.PROCESSING_STATUS) {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                try {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                catch (IOException e) {
                    logger.error("cannot make file {}", (Object)file.getPath(), (Object)e);
                    md5OfReceiver = Boolean.toString(Boolean.FALSE);
                }
            }
            try (FileOutputStream fos = new FileOutputStream(file, true);){
                FileChannel channel = fos.getChannel();
                channel.write(dataToReceive);
            }
            catch (IOException e) {
                logger.error("cannot insert data to file {}", (Object)file.getPath(), (Object)e);
                md5OfReceiver = Boolean.toString(Boolean.FALSE);
            }
        } else {
            try (FileInputStream fis = new FileInputStream(filePath);){
                int n;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[0x4000000];
                while ((n = fis.read(buffer)) != -1) {
                    md.update(buffer, 0, n);
                }
                md5OfReceiver = new BigInteger(1, md.digest()).toString(16);
                if (md5OfSender.equals(md5OfReceiver)) {
                    this.fileNum.set(this.fileNum.get() + 1);
                    logger.info(String.format("Receiver has received %d files from sender", this.fileNum.get()));
                } else {
                    FileUtils.forceDelete((File)new File(filePath));
                }
            }
            catch (Exception e) {
                logger.error("Receiver cannot generate md5 {}", (Object)filePath, (Object)e);
            }
        }
        return md5OfReceiver;
    }

    public boolean load() {
        try {
            this.getFileNodeInfo();
            this.loadData();
        }
        catch (Exception e) {
            logger.error("fail to load data", (Throwable)e);
            return false;
        }
        return true;
    }

    public void getFileNodeInfo() throws IOException {
        File dataFileRoot = new File(this.syncDataPath);
        File[] files = dataFileRoot.listFiles();
        int processedNum = 0;
        for (File storageGroupPB : files) {
            File[] filesSG;
            ArrayList<String> filesPath = new ArrayList<String>();
            for (File fileTF : filesSG = storageGroupPB.listFiles()) {
                HashMap<String, Long> startTimeMap = new HashMap<String, Long>();
                HashMap<String, Long> endTimeMap = new HashMap<String, Long>();
                TsFileSequenceReader reader = null;
                try {
                    reader = new TsFileSequenceReader(fileTF.getPath());
                    Map deviceIdMap = reader.readFileMetadata().getDeviceMap();
                    for (String key : deviceIdMap.keySet()) {
                        TsDeviceMetadataIndex device = (TsDeviceMetadataIndex)deviceIdMap.get(key);
                        startTimeMap.put(key, device.getStartTime());
                        endTimeMap.put(key, device.getEndTime());
                    }
                }
                catch (IOException e) {
                    logger.error("Unable to read tsfile {}", (Object)fileTF.getPath());
                    throw new IOException(e);
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error("Cannot close tsfile stream {}", (Object)fileTF.getPath());
                        throw new IOException(e);
                    }
                }
                this.fileNodeStartTime.get().put(fileTF.getPath(), startTimeMap);
                this.fileNodeEndTime.get().put(fileTF.getPath(), endTimeMap);
                filesPath.add(fileTF.getPath());
                logger.info(String.format("Get tsfile info has complete : %d/%d", ++processedNum, this.fileNum.get()));
                this.fileNodeMap.get().put(storageGroupPB.getName(), filesPath);
            }
        }
    }

    public void loadData() throws StorageEngineException {
        this.syncDataPath = FilePathUtils.regularizePath(this.syncDataPath);
        int processedNum = 0;
        for (String storageGroup : this.fileNodeMap.get().keySet()) {
            List<String> filesPath = this.fileNodeMap.get().get(storageGroup);
            Collections.sort(filesPath, (o1, o2) -> {
                Map<String, Long> startTimePath1 = this.fileNodeStartTime.get().get(o1);
                Map<String, Long> endTimePath2 = this.fileNodeEndTime.get().get(o2);
                for (Map.Entry<String, Long> entry : endTimePath2.entrySet()) {
                    if (!startTimePath1.containsKey(entry.getKey())) continue;
                    if (startTimePath1.get(entry.getKey()) > entry.getValue()) {
                        return 1;
                    }
                    return -1;
                }
                return 0;
            });
            for (String path : filesPath) {
                Map<String, Long> startTimeMap = this.fileNodeStartTime.get().get(path);
                Map<String, Long> endTimeMap = this.fileNodeEndTime.get().get(path);
                String header = this.syncDataPath;
                String relativePath = path.substring(header.length());
                TsFileResource fileNode = new TsFileResource(new File(DirectoryManager.getInstance().getNextFolderIndexForSequenceFile() + File.separator + relativePath), startTimeMap, endTimeMap);
                try {
                    if (!STORAGE_GROUP_MANAGER.appendFileToStorageGroupProcessor(storageGroup, fileNode, path)) {
                        if (this.config.isUpdateHistoricalDataPossibility()) {
                            this.loadOldData(path);
                        } else {
                            List<String> overlapFiles = STORAGE_GROUP_MANAGER.getOverlapFiles(storageGroup, fileNode, this.uuid.get());
                            if (overlapFiles.isEmpty()) {
                                this.loadOldData(path);
                            } else {
                                this.loadOldData(path, overlapFiles);
                            }
                        }
                    }
                }
                catch (IOException | ProcessorException | StorageEngineException e) {
                    logger.error("Can not load external file {}", (Object)path);
                    throw new StorageEngineException(e);
                }
                logger.info(String.format("Merging files has completed : %d/%d", ++processedNum, this.fileNum.get()));
            }
        }
    }

    public void loadOldData(String filePath) throws IOException, ProcessorException {
        HashSet<String> timeseriesSet = new HashSet<String>();
        TsFileSequenceReader reader = null;
        QueryProcessExecutor insertExecutor = new QueryProcessExecutor();
        try {
            reader = new TsFileSequenceReader(filePath);
            Map deviceIdMap = reader.readFileMetadata().getDeviceMap();
            for (Map.Entry deviceMIEntry : deviceIdMap.entrySet()) {
                String deviceId = (String)deviceMIEntry.getKey();
                TsDeviceMetadataIndex deviceMI = (TsDeviceMetadataIndex)deviceMIEntry.getValue();
                TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(deviceMI);
                List rowGroupMetadataList = deviceMetadata.getChunkGroupMetaDataList();
                timeseriesSet.clear();
                for (ChunkGroupMetaData chunkGroupMetaData : rowGroupMetadataList) {
                    List chunkMetaDataList = chunkGroupMetaData.getChunkMetaDataList();
                    Iterator iterator = chunkMetaDataList.iterator();
                    while (iterator.hasNext()) {
                        ChunkMetaData chunkMetaData = (ChunkMetaData)iterator.next();
                        String measurementUID = chunkMetaData.getMeasurementUid();
                        measurementUID = deviceId + "." + measurementUID;
                        timeseriesSet.add(measurementUID);
                    }
                }
                ReadOnlyTsFile readTsFile = new ReadOnlyTsFile(reader);
                ArrayList<Path> paths = new ArrayList<Path>();
                paths.clear();
                for (String timeseries : timeseriesSet) {
                    paths.add(new Path(timeseries));
                }
                QueryExpression queryExpression = QueryExpression.create(paths, null);
                QueryDataSet queryDataSet = readTsFile.query(queryExpression);
                while (queryDataSet.hasNext()) {
                    RowRecord record = queryDataSet.next();
                    List fields = record.getFields();
                    ArrayList<String> measurementList = new ArrayList<String>();
                    ArrayList<String> insertValues = new ArrayList<String>();
                    for (int i = 0; i < fields.size(); ++i) {
                        Field field = (Field)fields.get(i);
                        if (field.isNull()) continue;
                        measurementList.add(((Path)paths.get(i)).getMeasurement());
                        if (((Field)fields.get(i)).getDataType() == TSDataType.TEXT) {
                            insertValues.add(String.format("'%s'", field.toString()));
                            continue;
                        }
                        insertValues.add(String.format("%s", field.toString()));
                    }
                    if (!insertExecutor.insert(new InsertPlan(deviceId, record.getTimestamp(), measurementList.toArray(new String[0]), insertValues.toArray(new String[0])))) continue;
                    throw new IOException("Inserting series data to IoTDB engine has failed.");
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not parse tsfile into SQL", (Throwable)e);
            throw new IOException(e);
        }
        catch (ProcessorException e) {
            logger.error("Meet error while processing non-query.");
            throw new ProcessorException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error("Cannot close file stream {}", (Object)filePath, (Object)e);
            }
        }
    }

    public void loadOldData(String filePath, List<String> overlapFiles) throws IOException, ProcessorException {
        HashSet<String> timeseriesList = new HashSet<String>();
        QueryProcessExecutor insertExecutor = new QueryProcessExecutor();
        Map<String, ReadOnlyTsFile> tsfilesReaders = this.openReaders(filePath, overlapFiles);
        try {
            TsFileSequenceReader reader = new TsFileSequenceReader(filePath);
            Map deviceIdMap = reader.readFileMetadata().getDeviceMap();
            for (String deviceID : deviceIdMap.keySet()) {
                TsDeviceMetadataIndex deviceMI = (TsDeviceMetadataIndex)deviceIdMap.get(deviceID);
                TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(deviceMI);
                List chunkGroupMetaDataList = deviceMetadata.getChunkGroupMetaDataList();
                timeseriesList.clear();
                for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
                    List chunkMetaDataList = chunkGroupMetaData.getChunkMetaDataList();
                    for (ChunkMetaData timeSeriesChunkMetaData : chunkMetaDataList) {
                        String measurementUID = timeSeriesChunkMetaData.getMeasurementUid();
                        measurementUID = deviceID + "." + measurementUID;
                        timeseriesList.add(measurementUID);
                    }
                }
                reader.close();
                ReadOnlyTsFile readOnlyTsFile = tsfilesReaders.get(filePath);
                ArrayList<Path> paths = new ArrayList<Path>();
                for (String timeseries : timeseriesList) {
                    paths.clear();
                    paths.add(new Path(timeseries));
                    HashSet<InsertPlan> originDataPoints = new HashSet<InsertPlan>();
                    QueryExpression queryExpression = QueryExpression.create(paths, null);
                    QueryDataSet queryDataSet = readOnlyTsFile.query(queryExpression);
                    Set<InsertPlan> newDataPoints = this.convertToInserPlans(queryDataSet, paths, deviceID);
                    for (String overlapFile : overlapFiles) {
                        ReadOnlyTsFile readTsFileOverlap = tsfilesReaders.get(overlapFile);
                        QueryDataSet queryDataSetOverlap = readTsFileOverlap.query(queryExpression);
                        originDataPoints.addAll(this.convertToInserPlans(queryDataSetOverlap, paths, deviceID));
                    }
                    if (originDataPoints.isEmpty()) {
                        for (InsertPlan insertPlan : newDataPoints) {
                            if (!insertExecutor.insert(insertPlan)) continue;
                            throw new IOException("Inserting series data to IoTDB engine has failed.");
                        }
                        continue;
                    }
                    for (InsertPlan insertPlan : newDataPoints) {
                        if (originDataPoints.contains(insertPlan) || !insertExecutor.insert(insertPlan)) continue;
                        throw new IOException("Inserting series data to IoTDB engine has failed.");
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error("Can not parse tsfile into SQL", (Throwable)e);
            throw new IOException(e);
        }
        catch (ProcessorException e) {
            logger.error("Meet error while processing non-query.", (Throwable)e);
            throw new ProcessorException(e);
        }
        finally {
            try {
                this.closeReaders(tsfilesReaders);
            }
            catch (IOException e) {
                logger.error("Cannot close file stream {}", (Object)filePath, (Object)e);
            }
        }
    }

    private Set<InsertPlan> convertToInserPlans(QueryDataSet queryDataSet, List<Path> paths, String deviceID) throws IOException {
        HashSet<InsertPlan> plans = new HashSet<InsertPlan>();
        while (queryDataSet.hasNext()) {
            RowRecord record = queryDataSet.next();
            List fields = record.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = (Field)fields.get(i);
                String[] measurementList = new String[1];
                if (field.isNull()) continue;
                measurementList[0] = paths.get(i).getMeasurement();
                InsertPlan insertPlan = new InsertPlan(deviceID, record.getTimestamp(), measurementList, new String[]{field.getDataType() == TSDataType.TEXT ? String.format("'%s'", field.toString()) : field.toString()});
                plans.add(insertPlan);
            }
        }
        return plans;
    }

    private Map<String, ReadOnlyTsFile> openReaders(String filePath, List<String> overlapFiles) throws IOException {
        HashMap<String, ReadOnlyTsFile> tsfileReaders = new HashMap<String, ReadOnlyTsFile>();
        tsfileReaders.put(filePath, new ReadOnlyTsFile(new TsFileSequenceReader(filePath)));
        for (String overlapFile : overlapFiles) {
            tsfileReaders.put(overlapFile, new ReadOnlyTsFile(new TsFileSequenceReader(overlapFile)));
        }
        return tsfileReaders;
    }

    private void closeReaders(Map<String, ReadOnlyTsFile> readers) throws IOException {
        for (ReadOnlyTsFile tsfileReader : readers.values()) {
            tsfileReader.close();
        }
    }

    public void cleanUp() {
        this.uuid.remove();
        this.fileNum.remove();
        this.fileNodeMap.remove();
        this.fileNodeStartTime.remove();
        this.fileNodeEndTime.remove();
        this.schemaFromSenderPath.remove();
        try {
            FileUtils.deleteDirectory((File)new File(this.syncFolderPath));
        }
        catch (IOException e) {
            logger.error("can not delete directory {}", (Object)this.syncFolderPath, (Object)e);
        }
        logger.info("Synchronization has finished!");
    }

    public Map<String, List<String>> getFileNodeMap() {
        return this.fileNodeMap.get();
    }

    public void setFileNodeMap(Map<String, List<String>> fileNodeMap) {
        this.fileNodeMap.set(fileNodeMap);
    }
}

