/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.HashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXService
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(JMXService.class);
    private JMXConnectorServer jmxConnectorServer;

    private JMXService() {
    }

    public static final JMXService getInstance() {
        return JMXServerHolder.INSTANCE;
    }

    public static void registerMBean(Object mbean, String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (!mbs.isRegistered(objectName)) {
                mbs.registerMBean(mbean, objectName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.error("Failed to registerMBean {}", (Object)name, (Object)e);
        }
    }

    public static void deregisterMBean(String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(name);
            if (mbs.isRegistered(objectName)) {
                mbs.unregisterMBean(objectName);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            logger.error("Failed to unregisterMBean {}", (Object)name, (Object)e);
        }
    }

    private JMXConnectorServer createJMXServer(boolean local) throws IOException {
        HashMap env = new HashMap();
        if (local) {
            InetAddress serverAddress = InetAddress.getLoopbackAddress();
            System.setProperty("java.rmi.server.hostname", serverAddress.getHostAddress());
        }
        int rmiPort = Integer.getInteger("com.sun.management.jmxremote.rmi.port", 0);
        return JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL("rmi", null, rmiPort), env, ManagementFactory.getPlatformMBeanServer());
    }

    @Override
    public ServiceType getID() {
        return ServiceType.JMX_SERVICE;
    }

    @Override
    public void start() throws StartupException {
        if (System.getProperty("com.sun.management.jmxremote.port") != null) {
            logger.warn("JMX settings in conf/{}.sh(Unix or OS X, if you use Windows, check conf/{}.bat) have been bypassed as the JMX connector server is already initialized. Please refer to {}.sh/bat for JMX configuration info", new Object[]{"iotdb-env", "iotdb-env", "iotdb-env"});
            return;
        }
        System.setProperty("java.rmi.server.randomIDs", "true");
        boolean localOnly = false;
        String jmxPort = System.getProperty("iotdb.jmx.remote.port");
        if (jmxPort == null) {
            localOnly = true;
            jmxPort = System.getProperty("iotdb.jmx.local.port");
        }
        if (jmxPort == null) {
            logger.warn("Failed to start {} because JMX port is undefined", (Object)this.getID().getName());
            return;
        }
        try {
            this.jmxConnectorServer = this.createJMXServer(localOnly);
            if (this.jmxConnectorServer == null) {
                return;
            }
            this.jmxConnectorServer.start();
            logger.info("{}: start {} successfully.", (Object)"IoTDB", (Object)this.getID().getName());
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to start %s because of %s", this.getID().getName(), e.getMessage());
            throw new StartupException(errorMessage, e);
        }
    }

    @Override
    public void stop() {
        if (this.jmxConnectorServer != null) {
            try {
                this.jmxConnectorServer.stop();
                logger.info("{}: close {} successfully", (Object)"IoTDB", (Object)this.getID().getName());
            }
            catch (IOException e) {
                logger.error("Failed to stop {} because of: ", (Object)this.getID().getName(), (Object)e);
            }
        }
    }

    private static class JMXServerHolder {
        private static final JMXService INSTANCE = new JMXService();

        private JMXServerHolder() {
        }
    }
}

