/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.seriesRelated;

import java.io.IOException;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.reader.IBatchReader;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.resourceRelated.SeqResourceIterateReader;
import org.apache.iotdb.db.query.reader.resourceRelated.UnseqResourceMergeReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TimeValuePairUtils;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesReaderWithoutValueFilter
implements IPointReader {
    private boolean hasCachedBatchData;
    private BatchData batchData;
    private IBatchReader seqResourceIterateReader;
    private IPointReader unseqResourceMergeReader;

    public SeriesReaderWithoutValueFilter(IBatchReader seqResourceIterateReader, IPointReader unseqResourceMergeReader) {
        this.seqResourceIterateReader = seqResourceIterateReader;
        this.unseqResourceMergeReader = unseqResourceMergeReader;
        this.hasCachedBatchData = false;
    }

    public SeriesReaderWithoutValueFilter(Path seriesPath, Filter timeFilter, QueryContext context) throws StorageEngineException, IOException {
        this(seriesPath, timeFilter, context, true);
    }

    protected SeriesReaderWithoutValueFilter(Path seriesPath, Filter filter, QueryContext context, boolean pushdownUnseq) throws StorageEngineException, IOException {
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context);
        SeqResourceIterateReader seqResourceIterateReader = new SeqResourceIterateReader(queryDataSource.getSeriesPath(), queryDataSource.getSeqResources(), filter, context);
        UnseqResourceMergeReader unseqResourceMergeReader = pushdownUnseq ? new UnseqResourceMergeReader(seriesPath, queryDataSource.getUnseqResources(), context, filter) : new UnseqResourceMergeReader(seriesPath, queryDataSource.getUnseqResources(), context, null);
        this.seqResourceIterateReader = seqResourceIterateReader;
        this.unseqResourceMergeReader = unseqResourceMergeReader;
        this.hasCachedBatchData = false;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasNextInBatchDataOrBatchReader()) {
            return true;
        }
        return this.unseqResourceMergeReader != null && this.unseqResourceMergeReader.hasNext();
    }

    @Override
    public TimeValuePair next() throws IOException {
        boolean hasNextPoint;
        boolean hasNextBatch = this.hasNextInBatchDataOrBatchReader();
        boolean bl = hasNextPoint = this.unseqResourceMergeReader != null && this.unseqResourceMergeReader.hasNext();
        if (hasNextBatch && hasNextPoint) {
            long timeInBatchData;
            long timeInPointReader = this.unseqResourceMergeReader.current().getTimestamp();
            if (timeInPointReader > (timeInBatchData = this.batchData.currentTime())) {
                TimeValuePair timeValuePair = TimeValuePairUtils.getCurrentTimeValuePair(this.batchData);
                this.batchData.next();
                return timeValuePair;
            }
            if (timeInPointReader == timeInBatchData) {
                this.batchData.next();
                return this.unseqResourceMergeReader.next();
            }
            return this.unseqResourceMergeReader.next();
        }
        if (hasNextBatch) {
            TimeValuePair timeValuePair = TimeValuePairUtils.getCurrentTimeValuePair(this.batchData);
            this.batchData.next();
            return timeValuePair;
        }
        if (hasNextPoint) {
            return this.unseqResourceMergeReader.next();
        }
        return null;
    }

    private boolean hasNextInBatchDataOrBatchReader() throws IOException {
        if (this.hasCachedBatchData && this.batchData.hasNext()) {
            return true;
        }
        this.hasCachedBatchData = false;
        while (this.seqResourceIterateReader != null && this.seqResourceIterateReader.hasNext()) {
            this.batchData = this.seqResourceIterateReader.nextBatch();
            if (!this.batchData.hasNext()) continue;
            this.hasCachedBatchData = true;
            return true;
        }
        return false;
    }

    @Override
    public TimeValuePair current() throws IOException {
        throw new IOException("current() in SeriesReaderWithoutValueFilter is an empty method.");
    }

    @Override
    public void close() throws IOException {
        this.seqResourceIterateReader.close();
        this.unseqResourceMergeReader.close();
    }
}

