/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.seriesRelated;

import java.io.IOException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.IBatchReader;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderWithoutValueFilter;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class SeriesReaderWithValueFilter
extends SeriesReaderWithoutValueFilter {
    private Filter filter;
    private boolean hasCachedValue;
    private TimeValuePair timeValuePair;

    public SeriesReaderWithValueFilter(Path seriesPath, Filter filter, QueryContext context) throws StorageEngineException, IOException {
        super(seriesPath, filter, context, false);
        this.filter = filter;
    }

    public SeriesReaderWithValueFilter(IBatchReader seqResourceIterateReader, IPointReader unseqResourceMergeReader, Filter filter) {
        super(seqResourceIterateReader, unseqResourceMergeReader);
        this.filter = filter;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasCachedValue) {
            return true;
        }
        while (super.hasNext()) {
            this.timeValuePair = super.next();
            if (!this.filter.satisfy(this.timeValuePair.getTimestamp(), this.timeValuePair.getValue().getValue())) continue;
            this.hasCachedValue = true;
            return true;
        }
        return false;
    }

    @Override
    public TimeValuePair next() throws IOException {
        if (this.hasCachedValue || this.hasNext()) {
            this.hasCachedValue = false;
            return this.timeValuePair;
        }
        throw new IOException("data reader is out of bound.");
    }

    @Override
    public TimeValuePair current() {
        return this.timeValuePair;
    }
}

