/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.chunkRelated.DiskChunkReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReaderByTimestamp;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReaderByTimestamp;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;

public class UnseqResourceReaderByTimestamp
extends PriorityMergeReaderByTimestamp {
    public UnseqResourceReaderByTimestamp(Path seriesPath, List<TsFileResource> unseqResources, QueryContext context) throws IOException {
        int priorityValue = 1;
        for (TsFileResource tsFileResource : unseqResources) {
            List metaDataList;
            TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(tsFileResource.getFile().getPath(), tsFileResource.isClosed());
            if (tsFileResource.isClosed()) {
                MetadataQuerierByFileImpl metadataQuerier = new MetadataQuerierByFileImpl(tsFileReader);
                metaDataList = metadataQuerier.getChunkMetaDataList(seriesPath);
                List<Modification> pathModifications = context.getPathModifications(tsFileResource.getModFile(), seriesPath.getFullPath());
                if (!pathModifications.isEmpty()) {
                    QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
                }
            } else {
                metaDataList = tsFileResource.getChunkMetaDatas();
            }
            ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(tsFileReader);
            for (ChunkMetaData chunkMetaData : metaDataList) {
                Chunk chunk = chunkLoader.getChunk(chunkMetaData);
                ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(chunk);
                this.addReaderWithPriority(new DiskChunkReaderByTimestamp(chunkReader), priorityValue);
                ++priorityValue;
            }
            if (tsFileResource.isClosed()) continue;
            this.addReaderWithPriority(new MemChunkReaderByTimestamp(tsFileResource.getReadOnlyMemChunk()), priorityValue++);
        }
    }
}

