/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.resourceRelated;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.fileRelated.FileSeriesReaderByTimestampAdapter;
import org.apache.iotdb.db.query.reader.fileRelated.UnSealedTsFileReaderByTimestamp;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.ChunkLoader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderByTimestamp;

public class SeqResourceReaderByTimestamp
implements IReaderByTimestamp {
    protected Path seriesPath;
    private List<TsFileResource> seqResources;
    private QueryContext context;
    private int nextIntervalFileIndex;
    private IReaderByTimestamp seriesReader;

    public SeqResourceReaderByTimestamp(Path seriesPath, List<TsFileResource> seqResources, QueryContext context) {
        this.seriesPath = seriesPath;
        this.seqResources = seqResources;
        this.context = context;
        this.nextIntervalFileIndex = 0;
        this.seriesReader = null;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        Object value = null;
        if (this.seriesReader != null && ((value = this.seriesReader.getValueInTimestamp(timestamp)) != null || this.seriesReader.hasNext())) {
            return value;
        }
        while (this.nextIntervalFileIndex < this.seqResources.size()) {
            boolean isConstructed;
            if (!(isConstructed = this.constructNextReader(this.nextIntervalFileIndex++, timestamp)) || (value = this.seriesReader.getValueInTimestamp(timestamp)) == null && !this.seriesReader.hasNext()) continue;
            return value;
        }
        return value;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.seriesReader != null && this.seriesReader.hasNext()) {
            return true;
        }
        while (this.nextIntervalFileIndex < this.seqResources.size()) {
            TsFileResource tsFileResource;
            this.seriesReader = (tsFileResource = this.seqResources.get(this.nextIntervalFileIndex++)).isClosed() ? this.initSealedTsFileReaderByTimestamp(tsFileResource, this.context) : new UnSealedTsFileReaderByTimestamp(tsFileResource);
            if (!this.seriesReader.hasNext()) continue;
            return true;
        }
        return false;
    }

    private boolean constructNextReader(int idx, long timestamp) throws IOException {
        TsFileResource tsFileResource = this.seqResources.get(idx);
        if (tsFileResource.isClosed()) {
            if (this.isTsFileNotSatisfied(tsFileResource, timestamp)) {
                return false;
            }
            this.seriesReader = this.initSealedTsFileReaderByTimestamp(tsFileResource, this.context);
            return true;
        }
        if (tsFileResource.getEndTimeMap().size() != 0 && this.isTsFileNotSatisfied(tsFileResource, timestamp)) {
            return false;
        }
        this.seriesReader = new UnSealedTsFileReaderByTimestamp(tsFileResource);
        return true;
    }

    private boolean isTsFileNotSatisfied(TsFileResource tsFile, long timestamp) {
        return tsFile.getEndTimeMap().get(this.seriesPath.getDevice()) < timestamp;
    }

    private IReaderByTimestamp initSealedTsFileReaderByTimestamp(TsFileResource sealedTsFile, QueryContext context) throws IOException {
        TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(sealedTsFile.getFile().getPath(), true);
        MetadataQuerierByFileImpl metadataQuerier = new MetadataQuerierByFileImpl(tsFileReader);
        List metaDataList = metadataQuerier.getChunkMetaDataList(this.seriesPath);
        List<Modification> pathModifications = context.getPathModifications(sealedTsFile.getModFile(), this.seriesPath.getFullPath());
        if (!pathModifications.isEmpty()) {
            QueryUtils.modifyChunkMetaData(metaDataList, pathModifications);
        }
        ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(tsFileReader);
        return new FileSeriesReaderByTimestampAdapter(new FileSeriesReaderByTimestamp((ChunkLoader)chunkLoader, metaDataList));
    }
}

