/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.fileRelated;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReader;
import org.apache.iotdb.db.query.reader.fileRelated.FileSeriesReaderAdapter;
import org.apache.iotdb.db.query.reader.universal.IterateReader;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoader;
import org.apache.iotdb.tsfile.read.controller.ChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReader;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.series.FileSeriesReaderWithoutFilter;

public class UnSealedTsFileIterateReader
extends IterateReader {
    private TsFileResource unsealedTsFile;
    private Filter filter;
    private boolean enableReverse;

    public UnSealedTsFileIterateReader(TsFileResource unsealedTsFile, Filter filter, boolean isReverse) {
        super(2);
        this.enableReverse = isReverse;
        this.unsealedTsFile = unsealedTsFile;
        this.filter = filter;
    }

    @Override
    protected boolean constructNextReader(int idx) throws IOException {
        this.currentSeriesReader = idx == 0 ? (this.enableReverse ? new MemChunkReader(this.unsealedTsFile.getReadOnlyMemChunk(), this.filter) : this.initUnSealedTsFileDiskReader(this.unsealedTsFile, this.filter)) : (this.enableReverse ? this.initUnSealedTsFileDiskReader(this.unsealedTsFile, this.filter) : new MemChunkReader(this.unsealedTsFile.getReadOnlyMemChunk(), this.filter));
        return true;
    }

    private IAggregateReader initUnSealedTsFileDiskReader(TsFileResource unSealedTsFile, Filter filter) throws IOException {
        List<ChunkMetaData> metaDataList = unSealedTsFile.getChunkMetaDatas();
        if (this.enableReverse && metaDataList != null && !metaDataList.isEmpty()) {
            Collections.reverse(metaDataList);
        }
        TsFileSequenceReader unClosedTsFileReader = FileReaderManager.getInstance().get(unSealedTsFile.getFile().getPath(), false);
        ChunkLoaderImpl chunkLoader = new ChunkLoaderImpl(unClosedTsFileReader);
        Object fileSeriesReader = filter == null ? new FileSeriesReaderWithoutFilter((ChunkLoader)chunkLoader, metaDataList) : new FileSeriesReaderWithFilter((ChunkLoader)chunkLoader, metaDataList, filter);
        return new FileSeriesReaderAdapter((FileSeriesReader)fileSeriesReader);
    }
}

