/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.io.IOException;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;

public class DiskChunkReaderByTimestamp
implements IReaderByTimestamp {
    private ChunkReaderByTimestamp chunkReaderByTimestamp;
    private BatchData data;

    public DiskChunkReaderByTimestamp(ChunkReaderByTimestamp chunkReaderByTimestamp) {
        this.chunkReaderByTimestamp = chunkReaderByTimestamp;
    }

    @Override
    public Object getValueInTimestamp(long timestamp) throws IOException {
        if (!this.hasNext()) {
            return null;
        }
        while (this.data != null) {
            Object value = this.data.getValueInTimestamp(timestamp);
            if (value != null) {
                return value;
            }
            if (this.data.hasNext()) {
                return null;
            }
            this.chunkReaderByTimestamp.setCurrentTimestamp(timestamp);
            if (this.chunkReaderByTimestamp.hasNextBatch()) {
                this.data = this.chunkReaderByTimestamp.nextBatch();
                continue;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.data != null && this.data.hasNext()) {
            return true;
        }
        if (this.chunkReaderByTimestamp != null && this.chunkReaderByTimestamp.hasNextBatch()) {
            this.data = this.chunkReaderByTimestamp.nextBatch();
            return true;
        }
        return false;
    }
}

