/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.fill;

import java.io.IOException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.UnSupportedFillTypeException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;

public class LinearFill
extends IFill {
    private long beforeRange;
    private long afterRange;

    public LinearFill(long beforeRange, long afterRange) {
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public LinearFill(TSDataType dataType, long queryTime, long beforeRange, long afterRange) {
        super(dataType, queryTime);
        this.beforeRange = beforeRange;
        this.afterRange = afterRange;
    }

    public long getBeforeRange() {
        return this.beforeRange;
    }

    public void setBeforeRange(long beforeRange) {
        this.beforeRange = beforeRange;
    }

    public long getAfterRange() {
        return this.afterRange;
    }

    public void setAfterRange(long afterRange) {
        this.afterRange = afterRange;
    }

    @Override
    public IFill copy(Path path) {
        return new LinearFill(this.dataType, this.queryTime, this.beforeRange, this.afterRange);
    }

    @Override
    public void constructReaders(Path path, QueryContext context) throws IOException, StorageEngineException {
        super.constructReaders(path, context, this.beforeRange);
    }

    @Override
    public IPointReader getFillResult() throws IOException {
        TimeValuePair beforePair = null;
        TimeValuePair afterPair = null;
        while (this.allDataReader.hasNext() && (afterPair = this.allDataReader.next()).getTimestamp() <= this.queryTime) {
            beforePair = afterPair;
        }
        if (beforePair == null || beforePair.getTimestamp() == this.queryTime) {
            return new IFill.TimeValuePairPointReader(beforePair);
        }
        if (this.afterRange == -1L) {
            return new IFill.TimeValuePairPointReader(this.average(beforePair, afterPair));
        }
        if (afterPair.getTimestamp() > this.queryTime + this.afterRange || afterPair.getTimestamp() < this.queryTime) {
            return new IFill.TimeValuePairPointReader(new TimeValuePair(this.queryTime, null));
        }
        return new IFill.TimeValuePairPointReader(this.average(beforePair, afterPair));
    }

    private TimeValuePair average(TimeValuePair beforePair, TimeValuePair afterPair) {
        double totalTimeLength = (double)afterPair.getTimestamp() - (double)beforePair.getTimestamp();
        double beforeTimeLength = this.queryTime - beforePair.getTimestamp();
        switch (this.dataType) {
            case INT32: {
                int startIntValue = beforePair.getValue().getInt();
                int endIntValue = afterPair.getValue().getInt();
                int fillIntValue = startIntValue + (int)((double)(endIntValue - startIntValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType(TSDataType.INT32, fillIntValue));
                break;
            }
            case INT64: {
                long startLongValue = beforePair.getValue().getLong();
                long endLongValue = afterPair.getValue().getLong();
                long fillLongValue = startLongValue + (long)((double)(endLongValue - startLongValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType(TSDataType.INT64, fillLongValue));
                break;
            }
            case FLOAT: {
                float startFloatValue = beforePair.getValue().getFloat();
                float endFloatValue = afterPair.getValue().getFloat();
                float fillFloatValue = startFloatValue + (float)((double)(endFloatValue - startFloatValue) / totalTimeLength * beforeTimeLength);
                beforePair.setValue(TsPrimitiveType.getByType(TSDataType.FLOAT, Float.valueOf(fillFloatValue)));
                break;
            }
            case DOUBLE: {
                double startDoubleValue = beforePair.getValue().getDouble();
                double endDoubleValue = afterPair.getValue().getDouble();
                double fillDoubleValue = startDoubleValue + (endDoubleValue - startDoubleValue) / totalTimeLength * beforeTimeLength;
                beforePair.setValue(TsPrimitiveType.getByType(TSDataType.DOUBLE, fillDoubleValue));
                break;
            }
            default: {
                throw new UnSupportedFillTypeException("Unsupported linear fill data type : " + this.dataType);
            }
        }
        beforePair.setTimestamp(this.queryTime);
        return beforePair;
    }
}

