/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.EngineDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.EngineDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderWithoutValueFilter;
import org.apache.iotdb.db.query.timegenerator.EngineTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class EngineExecutor {
    private QueryExpression queryExpression;

    public EngineExecutor(QueryExpression queryExpression) {
        this.queryExpression = queryExpression;
    }

    public QueryDataSet executeWithoutValueFilter(QueryContext context) throws StorageEngineException, IOException {
        QueryResourceManager.getInstance().beginQueryOfGivenQueryPaths(context.getJobId(), this.queryExpression.getSelectedSeries());
        Filter timeFilter = null;
        if (this.queryExpression.hasQueryFilter()) {
            timeFilter = ((GlobalTimeExpression)this.queryExpression.getExpression()).getFilter();
        }
        ArrayList<IPointReader> readersOfSelectedSeries = new ArrayList<IPointReader>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : this.queryExpression.getSelectedSeries()) {
            try {
                dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
            }
            catch (PathErrorException e) {
                throw new StorageEngineException(e);
            }
            SeriesReaderWithoutValueFilter reader = new SeriesReaderWithoutValueFilter(path, timeFilter, context);
            readersOfSelectedSeries.add(reader);
        }
        try {
            return new EngineDataSetWithoutValueFilter(this.queryExpression.getSelectedSeries(), dataTypes, readersOfSelectedSeries);
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    public QueryDataSet executeWithValueFilter(QueryContext context) throws StorageEngineException, IOException {
        QueryResourceManager.getInstance().beginQueryOfGivenQueryPaths(context.getJobId(), this.queryExpression.getSelectedSeries());
        QueryResourceManager.getInstance().beginQueryOfGivenExpression(context.getJobId(), this.queryExpression.getExpression());
        EngineTimeGenerator timestampGenerator = new EngineTimeGenerator(this.queryExpression.getExpression(), context);
        ArrayList<IReaderByTimestamp> readersOfSelectedSeries = new ArrayList<IReaderByTimestamp>();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (Path path : this.queryExpression.getSelectedSeries()) {
            try {
                dataTypes.add(MManager.getInstance().getSeriesType(path.getFullPath()));
            }
            catch (PathErrorException e) {
                throw new StorageEngineException(e);
            }
            SeriesReaderByTimestamp seriesReaderByTimestamp = new SeriesReaderByTimestamp(path, context);
            readersOfSelectedSeries.add(seriesReaderByTimestamp);
        }
        return new EngineDataSetWithValueFilter(this.queryExpression.getSelectedSeries(), dataTypes, timestampGenerator, readersOfSelectedSeries);
    }
}

