/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.EngineTimeGenerator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;

public class EngineDataSetWithValueFilter
extends QueryDataSet {
    private EngineTimeGenerator timeGenerator;
    private List<IReaderByTimestamp> seriesReaderByTimestampList;
    private boolean hasCachedRowRecord;
    private RowRecord cachedRowRecord;

    public EngineDataSetWithValueFilter(List<Path> paths, List<TSDataType> dataTypes, EngineTimeGenerator timeGenerator, List<IReaderByTimestamp> readers) {
        super(paths, dataTypes);
        this.timeGenerator = timeGenerator;
        this.seriesReaderByTimestampList = readers;
    }

    public boolean hasNext() throws IOException {
        if (this.hasCachedRowRecord) {
            return true;
        }
        return this.cacheRowRecord();
    }

    public RowRecord next() throws IOException {
        if (!this.hasCachedRowRecord && !this.cacheRowRecord()) {
            return null;
        }
        this.hasCachedRowRecord = false;
        return this.cachedRowRecord;
    }

    private boolean cacheRowRecord() throws IOException {
        while (this.timeGenerator.hasNext()) {
            boolean hasField = false;
            long timestamp = this.timeGenerator.next();
            RowRecord rowRecord = new RowRecord(timestamp);
            for (int i = 0; i < this.seriesReaderByTimestampList.size(); ++i) {
                IReaderByTimestamp reader = this.seriesReaderByTimestampList.get(i);
                Object value = reader.getValueInTimestamp(timestamp);
                if (value == null) {
                    rowRecord.addField(new Field(null));
                    continue;
                }
                hasField = true;
                rowRecord.addField(this.getField(value, (TSDataType)this.dataTypes.get(i)));
            }
            if (!hasField) continue;
            this.hasCachedRowRecord = true;
            this.cachedRowRecord = rowRecord;
            break;
        }
        return this.hasCachedRowRecord;
    }

    public EngineTimeGenerator getTimeGenerator() {
        return this.timeGenerator;
    }

    public List<IReaderByTimestamp> getReaders() {
        return this.seriesReaderByTimestampList;
    }
}

