/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;

public class JobFileManager {
    private ConcurrentHashMap<Long, Set<String>> sealedFilePathsMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Long, Set<String>> unsealedFilePathsMap = new ConcurrentHashMap();

    public void addJobId(long jobId) {
        this.sealedFilePathsMap.computeIfAbsent(jobId, x -> new HashSet());
        this.unsealedFilePathsMap.computeIfAbsent(jobId, x -> new HashSet());
    }

    public void addUsedFilesForGivenJob(long jobId, QueryDataSource dataSource) {
        String path;
        for (TsFileResource tsFileResource : dataSource.getSeqResources()) {
            path = tsFileResource.getFile().getPath();
            this.addFilePathToMap(jobId, path, tsFileResource.isClosed());
        }
        for (TsFileResource tsFileResource : dataSource.getUnseqResources()) {
            path = tsFileResource.getFile().getPath();
            this.addFilePathToMap(jobId, path, tsFileResource.isClosed());
        }
    }

    void removeUsedFilesForGivenJob(long jobId) {
        for (String filePath : this.sealedFilePathsMap.get(jobId)) {
            FileReaderManager.getInstance().decreaseFileReaderReference(filePath, false);
        }
        this.sealedFilePathsMap.remove(jobId);
        for (String filePath : this.unsealedFilePathsMap.get(jobId)) {
            FileReaderManager.getInstance().decreaseFileReaderReference(filePath, true);
        }
        this.unsealedFilePathsMap.remove(jobId);
    }

    void addFilePathToMap(long jobId, String filePath, boolean isSealed) {
        ConcurrentHashMap<Long, Set<String>> pathMap;
        ConcurrentHashMap<Long, Set<String>> concurrentHashMap = pathMap = !isSealed ? this.unsealedFilePathsMap : this.sealedFilePathsMap;
        if (!pathMap.get(jobId).contains(filePath)) {
            pathMap.get(jobId).add(filePath);
            FileReaderManager.getInstance().increaseFileReaderReference(filePath, isSealed);
        }
    }
}

