/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MinValueAggrFunc
extends AggregateFunction {
    public MinValueAggrFunc(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        Comparable minVal = (Comparable)pageHeader.getStatistics().getMin();
        this.updateResult(minVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() < unsequenceReader.current().getTimestamp()) {
                this.updateResult((Comparable)dataInThisPage.currentValue());
                dataInThisPage.next();
                continue;
            }
            if (dataInThisPage.currentTime() == unsequenceReader.current().getTimestamp()) {
                this.updateResult((Comparable)unsequenceReader.current().getValue().getValue());
                dataInThisPage.next();
                unsequenceReader.next();
                continue;
            }
            this.updateResult((Comparable)unsequenceReader.current().getValue().getValue());
            unsequenceReader.next();
        }
        Comparable minVal = null;
        while (dataInThisPage.hasNext()) {
            if (minVal == null || minVal.compareTo(dataInThisPage.currentValue()) > 0) {
                minVal = (Comparable)dataInThisPage.currentValue();
            }
            dataInThisPage.next();
        }
        this.updateResult(minVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        long time;
        while (dataInThisPage.hasNext() && unsequenceReader.hasNext() && (time = Math.min(dataInThisPage.currentTime(), unsequenceReader.current().getTimestamp())) < bound) {
            if (dataInThisPage.currentTime() == time) {
                this.updateResult((Comparable)dataInThisPage.currentValue());
                dataInThisPage.next();
            }
            if (unsequenceReader.current().getTimestamp() != time) continue;
            this.updateResult((Comparable)unsequenceReader.current().getValue().getValue());
            unsequenceReader.next();
        }
        while (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            this.updateResult((Comparable)dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        Comparable minVal = null;
        while (unsequenceReader.hasNext()) {
            if (minVal == null || minVal.compareTo(unsequenceReader.current().getValue().getValue()) > 0) {
                minVal = (Comparable)unsequenceReader.current().getValue().getValue();
            }
            unsequenceReader.next();
        }
        this.updateResult(minVal);
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        Comparable minVal = null;
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            if (minVal == null || minVal.compareTo(unsequenceReader.current().getValue().getValue()) > 0) {
                minVal = (Comparable)unsequenceReader.current().getValue().getValue();
            }
            unsequenceReader.next();
        }
        this.updateResult(minVal);
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        Comparable minVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null || minVal != null && minVal.compareTo(value) <= 0) continue;
            minVal = (Comparable)value;
        }
        this.updateResult(minVal);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    private void updateResult(Comparable<Object> minVal) {
        if (minVal == null) {
            return;
        }
        if (!this.resultData.isSetValue() || minVal.compareTo(this.resultData.getValue()) < 0) {
            this.resultData.putTimeAndValue(0L, minVal);
        }
    }
}

