/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class MaxTimeAggrFunc
extends AggregateFunction {
    public MaxTimeAggrFunc() {
        super(TSDataType.INT64);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        long maxTimestamp = pageHeader.getMaxTimestamp();
        this.updateMaxTimeResult(0L, maxTimestamp);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) {
        int maxIndex = dataInThisPage.length() - 1;
        if (maxIndex < 0) {
            return;
        }
        long time = dataInThisPage.getTimeByIndex(maxIndex);
        this.updateMaxTimeResult(0L, time);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) {
        long time = -1L;
        while (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            time = dataInThisPage.currentTime();
            dataInThisPage.next();
        }
        if (time != -1L) {
            this.updateMaxTimeResult(0L, time);
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        TimeValuePair pair = null;
        while (unsequenceReader.hasNext()) {
            pair = unsequenceReader.next();
        }
        if (pair != null) {
            this.updateMaxTimeResult(0L, pair.getTimestamp());
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        TimeValuePair pair = null;
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            pair = unsequenceReader.next();
        }
        if (pair != null) {
            this.updateMaxTimeResult(0L, pair.getTimestamp());
        }
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        long time = -1L;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            time = timestamps[i];
        }
        if (time == -1L) {
            return;
        }
        this.updateMaxTimeResult(0L, time);
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    private void updateMaxTimeResult(long time, long value) {
        if (!this.resultData.isSetValue() || value >= this.resultData.getLongRet()) {
            this.resultData.setTimestamp(time);
            this.resultData.setLongRet(value);
        }
    }
}

