/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy.optimizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;
import org.apache.iotdb.db.exception.qp.LogicalOptimizeException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.strategy.optimizer.ILogicalOptimizer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatPathOptimizer
implements ILogicalOptimizer {
    private static final Logger LOG = LoggerFactory.getLogger(ConcatPathOptimizer.class);
    private static final String WARNING_NO_SUFFIX_PATHS = "given SFWOperator doesn't have suffix paths, cannot concat seriesPath";
    private IQueryProcessExecutor executor;

    public ConcatPathOptimizer(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    @Override
    public Operator transform(Operator operator) throws LogicalOptimizeException {
        FilterOperator filter;
        if (!(operator instanceof SFWOperator)) {
            LOG.warn("given operator isn't SFWOperator, cannot concat seriesPath");
            return operator;
        }
        SFWOperator sfwOperator = (SFWOperator)operator;
        FromOperator from = sfwOperator.getFromOperator();
        if (from == null) {
            LOG.warn("given SFWOperator doesn't have prefix paths, cannot concat seriesPath");
            return operator;
        }
        List<Path> prefixPaths = from.getPrefixPaths();
        if (prefixPaths.isEmpty()) {
            LOG.warn("given SFWOperator doesn't have prefix paths, cannot concat seriesPath");
            return operator;
        }
        SelectOperator select = sfwOperator.getSelectOperator();
        if (select == null) {
            LOG.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        List<Path> initialSuffixPaths = select.getSuffixPaths();
        if (initialSuffixPaths.isEmpty()) {
            LOG.warn(WARNING_NO_SUFFIX_PATHS);
            return operator;
        }
        this.concatSelect(prefixPaths, select);
        if (operator instanceof QueryOperator && ((QueryOperator)operator).hasSlimit()) {
            this.checkSlimitUsageConstraint(select, initialSuffixPaths, prefixPaths);
            int seriesLimit = ((QueryOperator)operator).getSeriesLimit();
            int seriesOffset = ((QueryOperator)operator).getSeriesOffset();
            this.slimitTrim(select, seriesLimit, seriesOffset);
        }
        if ((filter = sfwOperator.getFilterOperator()) == null) {
            return operator;
        }
        sfwOperator.setFilterOperator(this.concatFilter(prefixPaths, filter));
        return sfwOperator;
    }

    private List<Path> judgeSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (selectOperator == null) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        List<Path> suffixPaths = selectOperator.getSuffixPaths();
        if (suffixPaths.isEmpty()) {
            throw new LogicalOptimizeException(WARNING_NO_SUFFIX_PATHS);
        }
        return suffixPaths;
    }

    private void checkAggrOfSelectOperator(SelectOperator selectOperator) throws LogicalOptimizeException {
        if (!selectOperator.getAggregations().isEmpty() && selectOperator.getSuffixPaths().size() != selectOperator.getAggregations().size()) {
            throw new LogicalOptimizeException("Common queries and aggregated queries are not allowed to appear at the same time");
        }
    }

    private void extendListSafely(List<String> source, int index, List<String> target) {
        if (source != null && !source.isEmpty()) {
            target.add(source.get(index));
        }
    }

    private void concatSelect(List<Path> fromPaths, SelectOperator selectOperator) throws LogicalOptimizeException {
        List<Path> suffixPaths = this.judgeSelectOperator(selectOperator);
        this.checkAggrOfSelectOperator(selectOperator);
        ArrayList<Path> allPaths = new ArrayList<Path>();
        List<String> originAggregations = selectOperator.getAggregations();
        ArrayList<String> afterConcatAggregations = new ArrayList<String>();
        for (int i = 0; i < suffixPaths.size(); ++i) {
            Path selectPath = suffixPaths.get(i);
            if (selectPath.startWith("root")) {
                allPaths.add(selectPath);
                this.extendListSafely(originAggregations, i, afterConcatAggregations);
                continue;
            }
            for (Path fromPath : fromPaths) {
                if (!fromPath.startWith("root")) {
                    throw new LogicalOptimizeException("illegal from clause : " + fromPath.getFullPath());
                }
                allPaths.add(Path.addPrefixPath((Path)selectPath, (Path)fromPath));
                this.extendListSafely(originAggregations, i, afterConcatAggregations);
            }
        }
        this.removeStarsInPath(allPaths, afterConcatAggregations, selectOperator);
    }

    private boolean isWithStar(List<Path> suffixPaths, List<Path> prefixPaths, List<Path> fakePaths) {
        boolean isWithStar = false;
        Iterator<Path> iterSuffix = suffixPaths.iterator();
        while (iterSuffix.hasNext() && !isWithStar) {
            Path suffixPath = iterSuffix.next();
            if (suffixPath.getFullPath().contains("*")) {
                isWithStar = true;
                break;
            }
            Iterator<Path> iterPrefix = prefixPaths.iterator();
            while (iterPrefix.hasNext()) {
                Path fakePath = new Path(iterPrefix.next() + "." + suffixPath);
                if (fakePath.getFullPath().contains("*")) {
                    isWithStar = true;
                    continue;
                }
                fakePaths.add(fakePath);
            }
        }
        return isWithStar;
    }

    private void checkSlimitUsageConstraint(SelectOperator selectOperator, List<Path> initialSuffixPaths, List<Path> prefixPaths) throws LogicalOptimizeException {
        int sz;
        List<Path> transformedPaths = selectOperator.getSuffixPaths();
        ArrayList<Path> fakePaths = new ArrayList<Path>();
        boolean isWithStar = this.isWithStar(initialSuffixPaths, prefixPaths, fakePaths);
        if (!isWithStar && (sz = fakePaths.size()) == transformedPaths.size()) {
            int i;
            for (i = 0; i < sz && ((Path)fakePaths.get(i)).getFullPath().equals(transformedPaths.get(i).getFullPath()); ++i) {
            }
            if (i >= sz) {
                throw new LogicalOptimizeException("Wrong use of SLIMIT: SLIMIT is not allowed to be used with complete paths.");
            }
        }
    }

    public void slimitTrim(SelectOperator select, int seriesLimit, int seriesOffset) throws LogicalOptimizeException {
        List<Path> suffixList = select.getSuffixPaths();
        List<String> aggregations = select.getAggregations();
        int size = suffixList.size();
        if (seriesOffset >= size) {
            throw new LogicalOptimizeException("SOFFSET <SOFFSETValue>: SOFFSETValue exceeds the range.");
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        ArrayList<Path> trimedSuffixList = new ArrayList<Path>(suffixList.subList(seriesOffset, endPosition));
        select.setSuffixPathList(trimedSuffixList);
        if (aggregations != null && !aggregations.isEmpty()) {
            ArrayList<String> trimedAggregations = new ArrayList<String>(aggregations.subList(seriesOffset, endPosition));
            select.setAggregations(trimedAggregations);
        }
    }

    private FilterOperator concatFilter(List<Path> fromPaths, FilterOperator operator) throws LogicalOptimizeException {
        if (!operator.isLeaf()) {
            ArrayList<FilterOperator> newFilterList = new ArrayList<FilterOperator>();
            for (FilterOperator child : operator.getChildren()) {
                newFilterList.add(this.concatFilter(fromPaths, child));
            }
            operator.setChildren(newFilterList);
            return operator;
        }
        BasicFunctionOperator basicOperator = (BasicFunctionOperator)operator;
        Path filterPath = basicOperator.getSinglePath();
        if (SQLConstant.isReservedPath(filterPath) || filterPath.startWith("root")) {
            return operator;
        }
        ArrayList<Path> concatPaths = new ArrayList<Path>();
        fromPaths.forEach(fromPath -> concatPaths.add(Path.addPrefixPath((Path)filterPath, (Path)fromPath)));
        List<Path> noStarPaths = this.removeStarsInPathWithUnique(concatPaths);
        if (noStarPaths.size() == 1) {
            basicOperator.setSinglePath(noStarPaths.get(0));
            return operator;
        }
        return this.constructTwoForkFilterTreeWithAnd(noStarPaths, operator);
    }

    private FilterOperator constructTwoForkFilterTreeWithAnd(List<Path> noStarPaths, FilterOperator operator) throws LogicalOptimizeException {
        FilterOperator filterTwoFolkTree;
        FilterOperator currentNode = filterTwoFolkTree = new FilterOperator(1);
        for (int i = 0; i < noStarPaths.size(); ++i) {
            if (i > 0 && i < noStarPaths.size() - 1) {
                FilterOperator newInnerNode = new FilterOperator(1);
                currentNode.addChildOperator(newInnerNode);
                currentNode = newInnerNode;
            }
            try {
                currentNode.addChildOperator(new BasicFunctionOperator(operator.getTokenIntType(), noStarPaths.get(i), ((BasicFunctionOperator)operator).getValue()));
                continue;
            }
            catch (LogicalOperatorException e) {
                throw new LogicalOptimizeException(e);
            }
        }
        return filterTwoFolkTree;
    }

    private List<Path> removeStarsInPathWithUnique(List<Path> paths) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        LinkedHashMap<String, Integer> pathMap = new LinkedHashMap<String, Integer>();
        try {
            for (Path path : paths) {
                List<String> all = this.executor.getAllPaths(path.getFullPath());
                for (String subPath : all) {
                    if (pathMap.containsKey(subPath)) continue;
                    pathMap.put(subPath, 1);
                }
            }
            for (String pathStr : pathMap.keySet()) {
                retPaths.add(new Path(pathStr));
            }
        }
        catch (MetadataErrorException e) {
            throw new LogicalOptimizeException("error when remove star: ", e);
        }
        return retPaths;
    }

    private void removeStarsInPath(List<Path> paths, List<String> afterConcatAggregations, SelectOperator selectOperator) throws LogicalOptimizeException {
        ArrayList<Path> retPaths = new ArrayList<Path>();
        ArrayList<String> newAggregations = new ArrayList<String>();
        for (int i = 0; i < paths.size(); ++i) {
            try {
                List<String> actualPaths = this.executor.getAllPaths(paths.get(i).getFullPath());
                for (String actualPath : actualPaths) {
                    retPaths.add(new Path(actualPath));
                    if (afterConcatAggregations == null || afterConcatAggregations.isEmpty()) continue;
                    newAggregations.add(afterConcatAggregations.get(i));
                }
                continue;
            }
            catch (MetadataErrorException e) {
                throw new LogicalOptimizeException("error when remove star: ", e);
            }
        }
        if (retPaths.isEmpty()) {
            throw new LogicalOptimizeException("do not select any existing series");
        }
        selectOperator.setSuffixPathList(retPaths);
        selectOperator.setAggregations(newAggregations);
    }
}

