/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.util.List;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;
import org.apache.iotdb.db.exception.qp.QueryProcessorException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.MetadataOperator;
import org.apache.iotdb.db.qp.logical.sys.PropertyOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.MetadataPlan;
import org.apache.iotdb.db.qp.physical.sys.PropertyPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class PhysicalGenerator {
    private IQueryProcessExecutor executor;

    public PhysicalGenerator(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    public PhysicalPlan transformToPhysicalPlan(Operator operator) throws QueryProcessorException {
        switch (operator.getType()) {
            case AUTHOR: {
                AuthorOperator author = (AuthorOperator)operator;
                try {
                    return new AuthorPlan(author.getAuthorType(), author.getUserName(), author.getRoleName(), author.getPassWord(), author.getNewPassword(), author.getPrivilegeList(), author.getNodeName());
                }
                catch (AuthException e) {
                    throw new QueryProcessorException(e);
                }
            }
            case LOADDATA: {
                LoadDataOperator loadData = (LoadDataOperator)operator;
                return new LoadDataPlan(loadData.getInputFilePath(), loadData.getMeasureType());
            }
            case SET_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case METADATA: {
                MetadataOperator metadata = (MetadataOperator)operator;
                return new MetadataPlan(metadata.getNamespaceType(), metadata.getPath(), metadata.getDataType(), metadata.getCompressor(), metadata.getEncoding(), metadata.getProps(), metadata.getDeletePathList());
            }
            case PROPERTY: {
                PropertyOperator property = (PropertyOperator)operator;
                return new PropertyPlan(property.getPropertyType(), property.getPropertyPath(), property.getMetadataPath());
            }
            case DELETE: {
                DeleteOperator delete = (DeleteOperator)operator;
                List<Path> paths = delete.getSelectedPaths();
                if (delete.getTime() <= 0L) {
                    throw new LogicalOperatorException("For Delete command, time must greater than 0.");
                }
                return new DeletePlan(delete.getTime(), paths);
            }
            case INSERT: {
                InsertOperator insert = (InsertOperator)operator;
                List<Path> paths = insert.getSelectedPaths();
                if (paths.size() != 1) {
                    throw new LogicalOperatorException("For Insert command, cannot specified more than one seriesPath:" + paths);
                }
                if (insert.getTime() <= 0L) {
                    throw new LogicalOperatorException("For Insert command, time must greater than 0.");
                }
                return new InsertPlan(paths.get(0).getFullPath(), insert.getTime(), insert.getMeasurementList(), insert.getValueList());
            }
            case QUERY: {
                QueryOperator query = (QueryOperator)operator;
                return this.transformQuery(query);
            }
        }
        throw new LogicalOperatorException("not supported operator type: " + (Object)((Object)operator.getType()));
    }

    private PhysicalPlan transformQuery(QueryOperator queryOperator) throws QueryProcessorException {
        QueryPlan queryPlan;
        if (queryOperator.isGroupBy()) {
            queryPlan = new GroupByPlan();
            ((GroupByPlan)queryPlan).setUnit(queryOperator.getUnit());
            ((GroupByPlan)queryPlan).setOrigin(queryOperator.getOrigin());
            ((GroupByPlan)queryPlan).setIntervals(queryOperator.getIntervals());
            ((GroupByPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else if (queryOperator.isFill()) {
            queryPlan = new FillQueryPlan();
            FilterOperator timeFilter = queryOperator.getFilterOperator();
            if (!timeFilter.isSingle()) {
                throw new QueryProcessorException("Slice query must select a single time point");
            }
            long time = Long.parseLong(((BasicFunctionOperator)timeFilter).getValue());
            ((FillQueryPlan)queryPlan).setQueryTime(time);
            ((FillQueryPlan)queryPlan).setFillType(queryOperator.getFillTypes());
        } else if (queryOperator.hasAggregation()) {
            queryPlan = new AggregationPlan();
            ((AggregationPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else {
            queryPlan = new QueryPlan();
        }
        List<Path> paths = queryOperator.getSelectedPaths();
        queryPlan.setPaths(paths);
        FilterOperator filterOperator = queryOperator.getFilterOperator();
        if (filterOperator != null) {
            IExpression expression = filterOperator.transformToExpression(this.executor);
            queryPlan.setExpression(expression);
        }
        queryPlan.checkPaths(this.executor);
        return queryPlan;
    }
}

