/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import org.antlr.runtime.Token;
import org.apache.iotdb.db.exception.ArgsErrorException;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.qp.IllegalASTFormatException;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;
import org.apache.iotdb.db.exception.qp.QueryProcessorException;
import org.apache.iotdb.db.qp.constant.DatetimeUtils;
import org.apache.iotdb.db.qp.constant.TSParserConstant;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.FromOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectOperator;
import org.apache.iotdb.db.qp.logical.crud.UpdateOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.MetadataOperator;
import org.apache.iotdb.db.qp.logical.sys.PropertyOperator;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.db.query.fill.LinearFill;
import org.apache.iotdb.db.query.fill.PreviousFill;
import org.apache.iotdb.db.sql.parse.AstNode;
import org.apache.iotdb.db.sql.parse.Node;
import org.apache.iotdb.db.sql.parse.TSParser;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;

public class LogicalGenerator {
    private static final String ERR_INCORRECT_AUTHOR_COMMAND = "illegal ast tree in grant author command, please check you SQL statement";
    private RootOperator initializedOperator = null;
    private ZoneId zoneId;

    public LogicalGenerator(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public RootOperator getLogicalPlan(AstNode astNode) throws QueryProcessorException, ArgsErrorException, MetadataErrorException {
        this.analyze(astNode);
        return this.initializedOperator;
    }

    private void analyze(AstNode astNode) throws QueryProcessorException, ArgsErrorException, MetadataErrorException {
        Token token = astNode.getToken();
        if (token == null) {
            throw new QueryProcessorException("given token is null");
        }
        int tokenIntType = token.getType();
        switch (tokenIntType) {
            case 113: {
                this.analyzeInsert(astNode);
                return;
            }
            case 137: {
                this.analyzeSelectedPath(astNode);
                return;
            }
            case 107: {
                this.analyzeFrom(astNode);
                return;
            }
            case 156: {
                this.analyzeWhere(astNode);
                return;
            }
            case 110: {
                this.analyzeGroupBy(astNode);
                return;
            }
            case 106: {
                this.analyzeFill(astNode);
                return;
            }
            case 152: {
                if (astNode.getChild(0).getType() == 153) {
                    this.analyzeAuthorUpdate(astNode);
                    return;
                }
                this.analyzeUpdate(astNode);
                return;
            }
            case 102: {
                switch (astNode.getChild(0).getType()) {
                    case 148: {
                        this.analyzeMetadataDelete(astNode);
                        break;
                    }
                    case 116: {
                        this.analyzePropertyDeleteLabel(astNode);
                        break;
                    }
                    default: {
                        this.analyzeDelete(astNode);
                    }
                }
                return;
            }
            case 139: {
                this.analyzeMetadataSetFileLevel(astNode);
                return;
            }
            case 94: {
                this.analyzePropertyAddLabel(astNode);
                return;
            }
            case 119: {
                this.analyzePropertyLink(astNode);
                return;
            }
            case 151: {
                this.analyzePropertyUnLink(astNode);
                return;
            }
            case 99: {
                switch (astNode.getChild(0).getType()) {
                    case 135: 
                    case 154: {
                        this.analyzeAuthorCreate(astNode);
                        break;
                    }
                    case 148: {
                        this.analyzeMetadataCreate(astNode);
                        break;
                    }
                    case 131: {
                        this.analyzePropertyCreate(astNode);
                        break;
                    }
                }
                return;
            }
            case 104: {
                switch (astNode.getChild(0).getType()) {
                    case 135: 
                    case 154: {
                        this.analyzeAuthorDrop(astNode);
                        break;
                    }
                }
                return;
            }
            case 109: {
                this.analyzeAuthorGrant(astNode);
                return;
            }
            case 134: {
                this.analyzeAuthorRevoke(astNode);
                return;
            }
            case 121: {
                this.analyzeDataLoad(astNode);
                return;
            }
            case 132: {
                this.initializedOperator = new QueryOperator(27);
                break;
            }
            case 120: {
                this.analyzeList(astNode);
                return;
            }
            case 117: {
                this.analyzeLimit(astNode);
                return;
            }
            case 141: {
                this.analyzeSlimit(astNode);
                return;
            }
            case 142: {
                this.analyzeSoffset(astNode);
                return;
            }
            default: {
                throw new QueryProcessorException("Not supported TSParser type" + tokenIntType);
            }
        }
        for (Node node : astNode.getChildren()) {
            this.analyze((AstNode)node);
        }
    }

    private void analyzeSlimit(AstNode astNode) throws LogicalOperatorException {
        int seriesLimit;
        AstNode unit = astNode.getChild(0);
        try {
            seriesLimit = Integer.parseInt(unit.getText().trim());
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("SLIMIT <SN>: SN should be Int32.");
        }
        if (seriesLimit <= 0) {
            throw new LogicalOperatorException("SLIMIT <SN>: SN must be a positive integer and can not be zero.");
        }
        ((QueryOperator)this.initializedOperator).setSeriesLimit(seriesLimit);
    }

    private void analyzeSoffset(AstNode astNode) throws LogicalOperatorException {
        AstNode unit = astNode.getChild(0);
        try {
            ((QueryOperator)this.initializedOperator).setSeriesOffset(Integer.parseInt(unit.getText().trim()));
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("SOFFSET <SOFFSETValue>: SOFFSETValue should be Int32.");
        }
    }

    private void analyzeLimit(AstNode astNode) throws LogicalOperatorException {
        int rowsLimit;
        AstNode unit = astNode.getChild(0);
        try {
            rowsLimit = Integer.parseInt(unit.getText().trim());
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("LIMIT <N>: N should be Int32.");
        }
        if (rowsLimit <= 0) {
            throw new LogicalOperatorException("LIMIT <N>: N must be a positive integer and can not be zero.");
        }
    }

    private void analyzeList(AstNode astNode) {
        int childrenSize = astNode.getChildren().size();
        if (childrenSize == 1) {
            this.analyzeSimpleList(astNode);
        } else if (childrenSize == 3) {
            this.analyzeComplexList(astNode);
        }
    }

    private void analyzeSimpleList(AstNode astNode) {
        int tokenType = astNode.getChild(0).getType();
        if (tokenType == 154) {
            this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER);
        } else if (tokenType == 135) {
            this.initializedOperator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE);
        }
    }

    private void analyzeComplexList(AstNode astNode) {
        int tokenType = astNode.getChild(1).getType();
        if (tokenType == 154) {
            AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
            this.initializedOperator = operator;
            operator.setUserName(astNode.getChild(1).getChild(0).getText());
            operator.setNodeNameList(this.parsePath(astNode.getChild(2)));
        } else if (tokenType == 135) {
            AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
            this.initializedOperator = operator;
            operator.setRoleName(astNode.getChild(1).getChild(0).getText());
            operator.setNodeNameList(this.parsePath(astNode.getChild(2)));
        } else if (tokenType == 95) {
            tokenType = astNode.getChild(0).getType();
            if (tokenType == 130) {
                tokenType = astNode.getChild(2).getType();
                if (tokenType == 154) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_PRIVILEGE);
                    this.initializedOperator = operator;
                    operator.setUserName(astNode.getChild(2).getChild(0).getText());
                } else if (tokenType == 135) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_PRIVILEGE);
                    this.initializedOperator = operator;
                    operator.setRoleName(astNode.getChild(2).getChild(0).getText());
                }
            } else {
                tokenType = astNode.getChild(2).getType();
                if (tokenType == 154) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_USER_ROLES);
                    this.initializedOperator = operator;
                    operator.setUserName(astNode.getChild(2).getChild(0).getText());
                } else if (tokenType == 135) {
                    AuthorOperator operator = new AuthorOperator(59, AuthorOperator.AuthorType.LIST_ROLE_USERS);
                    this.initializedOperator = operator;
                    operator.setRoleName(astNode.getChild(2).getChild(0).getText());
                }
            }
        }
    }

    private void analyzePropertyCreate(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(54, PropertyOperator.PropertyType.ADD_TREE);
        propertyOperator.setPropertyPath(new Path(astNode.getChild(0).getChild(0).getText()));
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyAddLabel(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(55, PropertyOperator.PropertyType.ADD_PROPERTY_LABEL);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 0);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyDeleteLabel(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(56, PropertyOperator.PropertyType.DELETE_PROPERTY_LABEL);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 0);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private Path parsePropertyAndLabel(AstNode astNode, int startIndex) {
        String label = astNode.getChild(startIndex).getChild(0).getText();
        String property = astNode.getChild(startIndex + 1).getChild(0).getText();
        return new Path(new String[]{property, label});
    }

    private void analyzePropertyLink(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(57, PropertyOperator.PropertyType.ADD_PROPERTY_TO_METADATA);
        Path metaPath = this.parsePath(astNode.getChild(0));
        propertyOperator.setMetadataPath(metaPath);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 1);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzePropertyUnLink(AstNode astNode) {
        PropertyOperator propertyOperator = new PropertyOperator(58, PropertyOperator.PropertyType.DEL_PROPERTY_FROM_METADATA);
        Path metaPath = this.parsePath(astNode.getChild(0));
        propertyOperator.setMetadataPath(metaPath);
        Path propertyLabel = this.parsePropertyAndLabel(astNode, 1);
        propertyOperator.setPropertyPath(propertyLabel);
        this.initializedOperator = propertyOperator;
    }

    private void analyzeMetadataCreate(AstNode astNode) throws MetadataErrorException {
        String compressor;
        Path series = this.parsePath(astNode.getChild(0).getChild(0));
        AstNode paramNode = astNode.getChild(1);
        String dataType = paramNode.getChild(0).getChild(0).getText();
        String encodingType = paramNode.getChild(1).getChild(0).getText();
        int offset = 2;
        if (paramNode.getChildren().size() > offset && paramNode.getChild(offset).getToken().getText().equals("TOK_COMPRESSOR")) {
            compressor = paramNode.getChild(offset).getChild(0).getText();
            ++offset;
        } else {
            compressor = TSFileConfig.compressor;
        }
        this.checkMetadataArgs(dataType, encodingType, compressor);
        HashMap<String, String> props = new HashMap<String, String>(paramNode.getChildCount() - offset + 1, 1.0f);
        while (offset < paramNode.getChildCount()) {
            AstNode node = paramNode.getChild(offset++);
            props.put(node.getChild(0).getText().toLowerCase(), node.getChild(1).getText());
        }
        MetadataOperator metadataOperator = new MetadataOperator(51, MetadataOperator.NamespaceType.ADD_PATH);
        metadataOperator.setPath(series);
        metadataOperator.setDataType(TSDataType.valueOf((String)dataType));
        metadataOperator.setEncoding(TSEncoding.valueOf((String)encodingType));
        metadataOperator.setProps(props);
        metadataOperator.setCompressor(CompressionType.valueOf((String)compressor));
        this.initializedOperator = metadataOperator;
    }

    private void analyzeMetadataDelete(AstNode astNode) {
        ArrayList<Path> deletePaths = new ArrayList<Path>();
        for (int i = 0; i < astNode.getChild(0).getChildCount(); ++i) {
            deletePaths.add(this.parsePath(astNode.getChild(0).getChild(i)));
        }
        MetadataOperator metadataOperator = new MetadataOperator(52, MetadataOperator.NamespaceType.DELETE_PATH);
        metadataOperator.setDeletePathList(deletePaths);
        this.initializedOperator = metadataOperator;
    }

    private void analyzeMetadataSetFileLevel(AstNode astNode) {
        MetadataOperator metadataOperator = new MetadataOperator(53, MetadataOperator.NamespaceType.SET_FILE_LEVEL);
        Path path = this.parsePath(astNode.getChild(0).getChild(0));
        metadataOperator.setPath(path);
        this.initializedOperator = metadataOperator;
    }

    private void analyzeInsert(AstNode astNode) throws QueryProcessorException {
        long timestamp;
        InsertOperator insertOp = new InsertOperator(24);
        this.initializedOperator = insertOp;
        this.analyzeSelectedPath(astNode.getChild(0));
        try {
            AstNode timeChild = astNode.getChild(1).getChild(0);
            if (timeChild.getToken().getType() != 144) {
                throw new LogicalOperatorException("need keyword 'timestamp'");
            }
            AstNode timeValue = astNode.getChild(2).getChild(0);
            timestamp = timeValue.getType() == 101 ? Long.valueOf(this.parseTokenTime(timeValue)).longValue() : Long.valueOf(astNode.getChild(2).getChild(0).getText()).longValue();
        }
        catch (NumberFormatException e) {
            throw new LogicalOperatorException("need a long value in insert clause, but given:" + astNode.getChild(2).getChild(0).getText());
        }
        if (astNode.getChild(1).getChildCount() != astNode.getChild(2).getChildCount()) {
            throw new QueryProcessorException("number of measurement is NOT EQUAL TO the number of values");
        }
        insertOp.setTime(timestamp);
        String[] measurementList = new String[astNode.getChild(1).getChildCount() - 1];
        for (int i = 1; i < astNode.getChild(1).getChildCount(); ++i) {
            measurementList[i - 1] = astNode.getChild(1).getChild(i).getText();
        }
        insertOp.setMeasurementList(measurementList);
        String[] valueList = new String[astNode.getChild(2).getChildCount() - 1];
        for (int i = 1; i < astNode.getChild(2).getChildCount(); ++i) {
            valueList[i - 1] = astNode.getChild(2).getChild(i).getText();
        }
        insertOp.setValueList(valueList);
    }

    private void analyzeUpdate(AstNode astNode) throws QueryProcessorException {
        if (astNode.getChildCount() > 3) {
            throw new LogicalOperatorException("UPDATE clause doesn't support multi-update yet.");
        }
        UpdateOperator updateOp = new UpdateOperator(26);
        this.initializedOperator = updateOp;
        FromOperator fromOp = new FromOperator(107);
        fromOp.addPrefixTablePath(this.parsePath(astNode.getChild(0)));
        updateOp.setFromOperator(fromOp);
        SelectOperator selectOp = new SelectOperator(137);
        selectOp.addSelectPath(this.parsePath(astNode.getChild(1).getChild(0)));
        updateOp.setSelectOperator(selectOp);
        updateOp.setValue(astNode.getChild(1).getChild(1).getText());
        this.analyzeWhere(astNode.getChild(2));
    }

    private void analyzeDelete(AstNode astNode) throws LogicalOperatorException {
        this.initializedOperator = new DeleteOperator(25);
        SelectOperator selectOp = new SelectOperator(137);
        int selChildCount = astNode.getChildCount() - 1;
        for (int i = 0; i < selChildCount; ++i) {
            AstNode child = astNode.getChild(i);
            if (child.getType() != 128) {
                throw new LogicalOperatorException("children FROM clause except last one must all be seriesPath like root.a.b, actual:" + child.getText());
            }
            Path tablePath = this.parsePath(child);
            selectOp.addSelectPath(tablePath);
        }
        ((SFWOperator)this.initializedOperator).setSelectOperator(selectOp);
        this.analyzeWhere(astNode.getChild(selChildCount));
        long deleteTime = this.parseDeleteTimeFilter((DeleteOperator)this.initializedOperator);
        ((DeleteOperator)this.initializedOperator).setTime(deleteTime);
    }

    private long parseDeleteTimeFilter(DeleteOperator operator) throws LogicalOperatorException {
        FilterOperator filterOperator = operator.getFilterOperator();
        if (!filterOperator.isLeaf()) {
            throw new LogicalOperatorException("For delete command, where clause must be like : time < XXX or time <= XXX");
        }
        if (filterOperator.getTokenIntType() != 14 && filterOperator.getTokenIntType() != 13) {
            throw new LogicalOperatorException("For delete command, where clause must be like : time < XXX or time <= XXX");
        }
        long time = Long.parseLong(((BasicFunctionOperator)filterOperator).getValue());
        if (filterOperator.getTokenIntType() == 14) {
            --time;
        }
        if (time <= 0L) {
            throw new LogicalOperatorException("delete Time:" + time + ", time must > 0");
        }
        return time;
    }

    private void analyzeFrom(AstNode node) throws LogicalOperatorException {
        int selChildCount = node.getChildCount();
        FromOperator from = new FromOperator(22);
        for (int i = 0; i < selChildCount; ++i) {
            AstNode child = node.getChild(i);
            if (child.getType() != 128) {
                throw new LogicalOperatorException("children FROM clause must all be seriesPath like root.a.b, actual:" + child.getText());
            }
            Path tablePath = this.parsePath(child);
            from.addPrefixTablePath(tablePath);
        }
        ((SFWOperator)this.initializedOperator).setFromOperator(from);
    }

    private void analyzeSelectedPath(AstNode astNode) throws LogicalOperatorException {
        int tokenIntType = astNode.getType();
        SelectOperator selectOp = new SelectOperator(137);
        if (tokenIntType == 137) {
            int selChildCount = astNode.getChildCount();
            for (int i = 0; i < selChildCount; ++i) {
                AstNode child = astNode.getChild(i);
                if (child.getChild(0).getType() == 97) {
                    AstNode cluster = child.getChild(0);
                    AstNode pathChild = cluster.getChild(0);
                    Path selectPath = this.parsePath(pathChild);
                    String aggregation = cluster.getChild(1).getText();
                    selectOp.addClusterPath(selectPath, aggregation);
                    continue;
                }
                Path selectPath = this.parsePath(child);
                selectOp.addSelectPath(selectPath);
            }
        } else if (tokenIntType == 128) {
            Path selectPath = this.parsePath(astNode);
            selectOp.addSelectPath(selectPath);
        } else {
            throw new LogicalOperatorException("children SELECT clause must all be seriesPath like root.a.b, actual:" + astNode.dump());
        }
        ((SFWOperator)this.initializedOperator).setSelectOperator(selectOp);
    }

    private void analyzeWhere(AstNode astNode) throws LogicalOperatorException {
        if (astNode.getType() != 156) {
            throw new LogicalOperatorException("given node is not WHERE! please check whether SQL statement is correct.");
        }
        if (astNode.getChildCount() != 1) {
            throw new LogicalOperatorException("where clause has" + astNode.getChildCount() + " child, please check whether SQL grammar is correct.");
        }
        FilterOperator whereOp = new FilterOperator(23);
        AstNode child = astNode.getChild(0);
        this.analyzeWhere(child, child.getType(), whereOp);
        ((SFWOperator)this.initializedOperator).setFilterOperator(whereOp.getChildren().get(0));
    }

    private void analyzeWhere(AstNode ast, int tokenIntType, FilterOperator filterOp) throws LogicalOperatorException {
        int childCount = ast.getChildCount();
        switch (tokenIntType) {
            case 44: {
                if (childCount != 1) {
                    throw new LogicalOperatorException("parsing where clause failed: NOT operator requries one param");
                }
                FilterOperator notOp = new FilterOperator(3);
                filterOp.addChildOperator(notOp);
                AstNode childAstNode = ast.getChild(0);
                int childNodeTokenType = childAstNode.getToken().getType();
                this.analyzeWhere(childAstNode, childNodeTokenType, notOp);
                break;
            }
            case 20: 
            case 49: {
                if (childCount != 2) {
                    throw new LogicalOperatorException("parsing where clause failed! node has " + childCount + " paramter.");
                }
                FilterOperator binaryOp = new FilterOperator(TSParserConstant.getTSTokenIntType(tokenIntType));
                filterOp.addChildOperator(binaryOp);
                for (int i = 0; i < childCount; ++i) {
                    AstNode childAstNode = ast.getChild(i);
                    int childNodeTokenType = childAstNode.getToken().getType();
                    this.analyzeWhere(childAstNode, childNodeTokenType, binaryOp);
                }
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 77: 
            case 78: 
            case 83: {
                Pair<Path, String> pair = this.parseLeafNode(ast);
                BasicFunctionOperator basic = new BasicFunctionOperator(TSParserConstant.getTSTokenIntType(tokenIntType), (Path)pair.left, (String)pair.right);
                filterOp.addChildOperator(basic);
                break;
            }
            default: {
                throw new LogicalOperatorException("unsupported token:" + tokenIntType);
            }
        }
    }

    private void analyzeGroupBy(AstNode astNode) throws LogicalOperatorException {
        AstNode originNode;
        SelectOperator selectOp = ((QueryOperator)this.initializedOperator).getSelectOperator();
        if (selectOp.getSuffixPaths().size() != selectOp.getAggregations().size()) {
            throw new LogicalOperatorException("Group by must bind each seriesPath with an aggregation function");
        }
        ((QueryOperator)this.initializedOperator).setGroupBy(true);
        int childCount = astNode.getChildCount();
        AstNode unit = astNode.getChild(0);
        long value = this.parseTimeUnit(unit);
        ((QueryOperator)this.initializedOperator).setUnit(value);
        AstNode intervalsNode = astNode.getChild(childCount - 1);
        int intervalCount = intervalsNode.getChildCount();
        ArrayList<Pair<Long, Long>> intervals = new ArrayList<Pair<Long, Long>>();
        for (int i = 0; i < intervalCount; ++i) {
            AstNode intervalNode = intervalsNode.getChild(i);
            AstNode startNode = intervalNode.getChild(0);
            long startTime = startNode.getType() == 101 ? Long.valueOf(this.parseTokenTime(startNode)).longValue() : Long.valueOf(startNode.getText()).longValue();
            AstNode endNode = intervalNode.getChild(1);
            long endTime = endNode.getType() == 101 ? Long.valueOf(this.parseTokenTime(endNode)).longValue() : Long.valueOf(endNode.getText()).longValue();
            intervals.add((Pair<Long, Long>)new Pair((Object)startTime, (Object)endTime));
        }
        ((QueryOperator)this.initializedOperator).setIntervals(intervals);
        long originTime = childCount == 3 ? ((originNode = astNode.getChild(1).getChild(0)).getType() == 101 ? Long.valueOf(this.parseTokenTime(originNode)).longValue() : Long.valueOf(originNode.getText()).longValue()) : this.parseTimeFormat("1970-1-01T00:00:00");
        ((QueryOperator)this.initializedOperator).setOrigin(originTime);
    }

    private void analyzeFill(AstNode node) throws LogicalOperatorException {
        FilterOperator filterOperator = ((SFWOperator)this.initializedOperator).getFilterOperator();
        if (!filterOperator.isLeaf() || filterOperator.getTokenIntType() != 11) {
            throw new LogicalOperatorException("Only \"=\" can be used in fill function");
        }
        EnumMap<TSDataType, IFill> fillTypes = new EnumMap<TSDataType, IFill>(TSDataType.class);
        int childNum = node.getChildCount();
        block4: for (int i = 0; i < childNum; ++i) {
            AstNode childNode = node.getChild(i);
            TSDataType dataType = this.parseTypeNode(childNode.getChild(0));
            AstNode fillTypeNode = childNode.getChild(1);
            switch (fillTypeNode.getType()) {
                case 118: {
                    this.checkTypeFill(dataType, 118);
                    if (fillTypeNode.getChildCount() == 2) {
                        long beforeRange = this.parseTimeUnit(fillTypeNode.getChild(0));
                        long afterRange = this.parseTimeUnit(fillTypeNode.getChild(1));
                        fillTypes.put(dataType, new LinearFill(beforeRange, afterRange));
                        continue block4;
                    }
                    if (fillTypeNode.getChildCount() == 0) {
                        fillTypes.put(dataType, new LinearFill(-1L, -1L));
                        continue block4;
                    }
                    throw new LogicalOperatorException("Linear fill type must have 0 or 2 valid time ranges");
                }
                case 129: {
                    this.checkTypeFill(dataType, 129);
                    if (fillTypeNode.getChildCount() == 1) {
                        long preRange = this.parseTimeUnit(fillTypeNode.getChild(0));
                        fillTypes.put(dataType, new PreviousFill(preRange));
                        continue block4;
                    }
                    if (fillTypeNode.getChildCount() == 0) {
                        fillTypes.put(dataType, new PreviousFill(-1L));
                        continue block4;
                    }
                    throw new LogicalOperatorException("Previous fill type must have 0 or 1 valid time range");
                }
            }
        }
        ((QueryOperator)this.initializedOperator).setFillTypes(fillTypes);
        ((QueryOperator)this.initializedOperator).setFill(true);
    }

    private void checkTypeFill(TSDataType dataType, int type) throws LogicalOperatorException {
        switch (dataType) {
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: {
                if (type != 118 && type != 129) {
                    throw new LogicalOperatorException(String.format("type %s cannot use %s fill function", dataType, TSParser.tokenNames[type]));
                }
                return;
            }
            case BOOLEAN: 
            case TEXT: {
                if (type != 129) {
                    throw new LogicalOperatorException(String.format("type %s cannot use %s fill function", dataType, TSParser.tokenNames[type]));
                }
                return;
            }
        }
    }

    private TSDataType parseTypeNode(AstNode typeNode) throws LogicalOperatorException {
        String type;
        switch (type = typeNode.getText().toLowerCase()) {
            case "int32": {
                return TSDataType.INT32;
            }
            case "int64": {
                return TSDataType.INT64;
            }
            case "float": {
                return TSDataType.FLOAT;
            }
            case "double": {
                return TSDataType.DOUBLE;
            }
            case "boolean": {
                return TSDataType.BOOLEAN;
            }
            case "text": {
                return TSDataType.TEXT;
            }
        }
        throw new LogicalOperatorException("not a valid fill type : " + type);
    }

    private long parseTimeUnit(AstNode node) throws LogicalOperatorException {
        String granu;
        long timeInterval = Long.parseLong(node.getChild(0).getText());
        if (timeInterval <= 0L) {
            throw new LogicalOperatorException("Interval must more than 0.");
        }
        switch (granu = node.getChild(1).getText()) {
            case "w": {
                timeInterval *= 7L;
            }
            case "d": {
                timeInterval *= 24L;
            }
            case "h": {
                timeInterval *= 60L;
            }
            case "m": {
                timeInterval *= 60L;
            }
            case "s": {
                timeInterval *= 1000L;
            }
        }
        return timeInterval;
    }

    private Pair<Path, String> parseLeafNode(AstNode node) throws LogicalOperatorException {
        String seriesValue;
        if (node.getChildCount() != 2) {
            throw new LogicalOperatorException("error format in SQL statement, please check whether SQL statement is correct.");
        }
        AstNode col = node.getChild(0);
        if (col.getType() != 128) {
            throw new LogicalOperatorException("error format in SQL statement, please check whether SQL statement is correct.");
        }
        Path seriesPath = this.parsePath(col);
        AstNode rightKey = node.getChild(1);
        if (rightKey.getType() == 128) {
            seriesValue = this.parsePath(rightKey).getFullPath();
        } else if (rightKey.getType() == 101) {
            if (!seriesPath.equals("time")) {
                throw new LogicalOperatorException("Date can only be used to time");
            }
            seriesValue = this.parseTokenTime(rightKey);
        } else {
            seriesValue = rightKey.getText();
        }
        return new Pair((Object)seriesPath, (Object)seriesValue);
    }

    private String parseTokenTime(AstNode astNode) throws LogicalOperatorException {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < astNode.getChildCount(); ++i) {
            sc.addTail(new String[]{astNode.getChild(i).getText()});
        }
        return this.parseTimeFormat(sc.toString()) + "";
    }

    public long parseTimeFormat(String timestampStr) throws LogicalOperatorException {
        if (timestampStr == null || timestampStr.trim().equals("")) {
            throw new LogicalOperatorException("input timestamp cannot be empty");
        }
        if (timestampStr.equalsIgnoreCase("now")) {
            return System.currentTimeMillis();
        }
        try {
            return DatetimeUtils.convertDatetimeStrToMillisecond(timestampStr, this.zoneId);
        }
        catch (Exception e) {
            throw new LogicalOperatorException(String.format("Input time format %s error. Input like yyyy-MM-dd HH:mm:ss, yyyy-MM-ddTHH:mm:ss or refer to user document for more info.", timestampStr));
        }
    }

    private Path parsePath(AstNode node) {
        String[] path;
        int childCount = node.getChildCount();
        if (childCount == 1 && node.getChild(0).getType() == 136) {
            AstNode childNode = node.getChild(0);
            childCount = childNode.getChildCount();
            path = new String[childCount + 1];
            path[0] = "root";
            for (int i = 0; i < childCount; ++i) {
                path[i + 1] = childNode.getChild(i).getText();
            }
        } else {
            path = new String[childCount];
            for (int i = 0; i < childCount; ++i) {
                path[i] = node.getChild(i).getText();
            }
        }
        return new Path(new StringContainer(path, "."));
    }

    private String parseStringWithQuoto(String src) throws IllegalASTFormatException {
        if (src.length() < 3 || src.charAt(0) != '\'' || src.charAt(src.length() - 1) != '\'') {
            throw new IllegalASTFormatException("error format for string with quoto:" + src);
        }
        return src.substring(1, src.length() - 1);
    }

    private void analyzeDataLoad(AstNode astNode) throws IllegalASTFormatException {
        int childCount = astNode.getChildCount();
        if (childCount < 3 || !"root".equals(astNode.getChild(1).getText())) {
            throw new IllegalASTFormatException("data load command: child count < 3\n" + astNode.dump());
        }
        String csvPath = astNode.getChild(0).getText();
        if (csvPath.length() < 3 || csvPath.charAt(0) != '\'' || csvPath.charAt(csvPath.length() - 1) != '\'') {
            throw new IllegalASTFormatException("data load: error format csvPath:" + csvPath);
        }
        StringContainer sc = new StringContainer(".");
        sc.addTail(new String[]{"root"});
        for (int i = 2; i < childCount; ++i) {
            String pathNode = astNode.getChild(i).getText();
            sc.addTail(new String[]{pathNode});
        }
        this.initializedOperator = new LoadDataOperator(45, csvPath.substring(1, csvPath.length() - 1), sc.toString());
    }

    private void analyzeAuthorCreate(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_USER);
            authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setPassWord(astNode.getChild(1).getChild(0).getText());
        } else if (childCount == 1) {
            authorOperator = new AuthorOperator(41, AuthorOperator.AuthorType.CREATE_ROLE);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
        } else {
            throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
        }
        this.initializedOperator = authorOperator;
    }

    private void analyzeAuthorUpdate(AstNode astNode) throws IllegalASTFormatException {
        AstNode user;
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 1) {
            authorOperator = new AuthorOperator(46, AuthorOperator.AuthorType.UPDATE_USER);
            user = astNode.getChild(0);
            if (user.getChildCount() != 2) {
                throw new IllegalASTFormatException("illegal ast tree in update password command, please check you SQL statement");
            }
        } else {
            throw new IllegalASTFormatException("illegal ast tree in update password command, please check you SQL statement");
        }
        authorOperator.setUserName(user.getChild(0).getText());
        authorOperator.setNewPassword(user.getChild(1).getText());
        this.initializedOperator = authorOperator;
    }

    private void analyzeAuthorDrop(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        block5: {
            block4: {
                int childCount = astNode.getChildCount();
                if (childCount != 1) break block4;
                switch (astNode.getChild(0).getType()) {
                    case 154: {
                        authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_USER);
                        authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                        break block5;
                    }
                    case 135: {
                        authorOperator = new AuthorOperator(42, AuthorOperator.AuthorType.DROP_ROLE);
                        authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                        break block5;
                    }
                    default: {
                        throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
                    }
                }
            }
            throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
        }
        this.initializedOperator = authorOperator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAuthorGrant(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE_TO_USER);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setUserName(astNode.getChild(1).getChild(0).getText());
        } else {
            if (childCount != 3) throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
            AstNode privilegesNode = astNode.getChild(1);
            String[] privileges = new String[privilegesNode.getChildCount()];
            for (int i = 0; i < privileges.length; ++i) {
                privileges[i] = this.parseStringWithQuoto(privilegesNode.getChild(i).getText());
            }
            Path nodePath = this.parsePath(astNode.getChild(2));
            if (astNode.getChild(0).getType() == 154) {
                authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_USER);
                authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            } else {
                if (astNode.getChild(0).getType() != 135) throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
                authorOperator = new AuthorOperator(43, AuthorOperator.AuthorType.GRANT_ROLE);
                authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            }
        }
        this.initializedOperator = authorOperator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void analyzeAuthorRevoke(AstNode astNode) throws IllegalASTFormatException {
        AuthorOperator authorOperator;
        int childCount = astNode.getChildCount();
        if (childCount == 2) {
            authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_ROLE_FROM_USER);
            authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
            authorOperator.setUserName(astNode.getChild(1).getChild(0).getText());
        } else {
            if (childCount != 3) throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
            AstNode privilegesNode = astNode.getChild(1);
            String[] privileges = new String[privilegesNode.getChildCount()];
            for (int i = 0; i < privileges.length; ++i) {
                privileges[i] = this.parseStringWithQuoto(privilegesNode.getChild(i).getText());
            }
            Path nodePath = this.parsePath(astNode.getChild(2));
            if (astNode.getChild(0).getType() == 154) {
                authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_USER);
                authorOperator.setUserName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            } else {
                if (astNode.getChild(0).getType() != 135) throw new IllegalASTFormatException(ERR_INCORRECT_AUTHOR_COMMAND);
                authorOperator = new AuthorOperator(44, AuthorOperator.AuthorType.REVOKE_ROLE);
                authorOperator.setRoleName(astNode.getChild(0).getChild(0).getText());
                authorOperator.setPrivilegeList(privileges);
                authorOperator.setNodeNameList(nodePath);
            }
        }
        this.initializedOperator = authorOperator;
    }

    private void checkMetadataArgs(String dataType, String encoding, String compressor) throws MetadataErrorException {
        TSEncoding tsEncoding;
        TSDataType tsDataType;
        if (dataType == null) {
            throw new MetadataErrorException("data type cannot be null");
        }
        try {
            tsDataType = TSDataType.valueOf((String)dataType);
        }
        catch (Exception e) {
            throw new MetadataErrorException(String.format("data type %s not support", dataType));
        }
        if (encoding == null) {
            throw new MetadataErrorException("encoding type cannot be null");
        }
        try {
            tsEncoding = TSEncoding.valueOf((String)encoding);
        }
        catch (Exception e) {
            throw new MetadataErrorException(String.format("encoding %s is not support", encoding));
        }
        try {
            CompressionType.valueOf((String)compressor);
        }
        catch (Exception e) {
            throw new MetadataErrorException(String.format("compressor %s is not support", compressor));
        }
        this.checkDataTypeEncoding(tsDataType, tsEncoding);
    }

    private void checkDataTypeEncoding(TSDataType tsDataType, TSEncoding tsEncoding) throws MetadataErrorException {
        boolean throwExp = false;
        switch (tsDataType) {
            case BOOLEAN: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            case INT32: 
            case INT64: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF)) break;
                throwExp = true;
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                if (tsEncoding.equals((Object)TSEncoding.RLE) || tsEncoding.equals((Object)TSEncoding.PLAIN) || tsEncoding.equals((Object)TSEncoding.TS_2DIFF) || tsEncoding.equals((Object)TSEncoding.GORILLA)) break;
                throwExp = true;
                break;
            }
            case TEXT: {
                if (tsEncoding.equals((Object)TSEncoding.PLAIN)) break;
                throwExp = true;
                break;
            }
            default: {
                throwExp = true;
            }
        }
        if (throwExp) {
            throw new MetadataErrorException(String.format("encoding %s does not support %s", tsEncoding, tsDataType));
        }
    }
}

