/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.PropertyOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class PropertyPlan
extends PhysicalPlan {
    private final PropertyOperator.PropertyType propertyType;
    private Path propertyPath;
    private Path metadataPath;

    public PropertyPlan(PropertyOperator.PropertyType propertyType, Path propertyPath, Path metadataPath) {
        super(false, Operator.OperatorType.PROPERTY);
        this.propertyType = propertyType;
        this.propertyPath = propertyPath;
        this.metadataPath = metadataPath;
    }

    public Path getPropertyPath() {
        return this.propertyPath;
    }

    public Path getMetadataPath() {
        return this.metadataPath;
    }

    public PropertyOperator.PropertyType getPropertyType() {
        return this.propertyType;
    }

    public String toString() {
        return "propertyPath: " + this.propertyPath.toString() + "\nmetadataPath: " + this.metadataPath + "\npropertyType: " + (Object)((Object)this.propertyType);
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.metadataPath != null) {
            ret.add(this.metadataPath);
        }
        if (this.propertyPath != null) {
            ret.add(this.propertyPath);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyPlan that = (PropertyPlan)o;
        return this.propertyType == that.propertyType && Objects.equals(this.propertyPath, that.propertyPath) && Objects.equals(this.metadataPath, that.metadataPath);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyType, this.propertyPath, this.metadataPath});
    }
}

