/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.util.List;
import org.apache.iotdb.db.exception.qp.QueryProcessorException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class QueryPlan
extends PhysicalPlan {
    private List<Path> paths = null;
    private IExpression expression = null;

    public QueryPlan() {
        super(true);
        this.setOperatorType(Operator.OperatorType.QUERY);
    }

    public QueryPlan(boolean isQuery, Operator.OperatorType operatorType) {
        super(isQuery, operatorType);
    }

    public void checkPaths(IQueryProcessExecutor executor) throws QueryProcessorException {
        for (Path path : this.paths) {
            if (executor.judgePathExists(path)) continue;
            throw new QueryProcessorException("Path doesn't exist: " + path);
        }
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public void setExpression(IExpression expression) {
        this.expression = expression;
    }

    @Override
    public List<Path> getPaths() {
        return this.paths;
    }

    public void setPaths(List<Path> paths) {
        this.paths = paths;
    }
}

