/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.crud;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;

public class InsertPlan
extends PhysicalPlan {
    private String deviceId;
    private String[] measurements;
    private TSDataType[] dataTypes;
    private String[] values;
    private long time;

    public InsertPlan() {
        super(false, Operator.OperatorType.INSERT);
    }

    public InsertPlan(String deviceId, long insertTime, String measurement, String insertValue) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = new String[]{measurement};
        this.values = new String[]{insertValue};
    }

    public InsertPlan(TSRecord tsRecord) {
        super(false, Operator.OperatorType.INSERT);
        this.deviceId = tsRecord.deviceId;
        this.time = tsRecord.time;
        this.measurements = new String[tsRecord.dataPointList.size()];
        this.dataTypes = new TSDataType[tsRecord.dataPointList.size()];
        this.values = new String[tsRecord.dataPointList.size()];
        for (int i = 0; i < tsRecord.dataPointList.size(); ++i) {
            this.measurements[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getMeasurementId();
            this.dataTypes[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getType();
            this.values[i] = ((DataPoint)tsRecord.dataPointList.get(i)).getValue().toString();
        }
    }

    public InsertPlan(String deviceId, long insertTime, String[] measurementList, String[] insertValues) {
        super(false, Operator.OperatorType.INSERT);
        this.time = insertTime;
        this.deviceId = deviceId;
        this.measurements = measurementList;
        this.values = insertValues;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public TSDataType[] getDataTypes() {
        return this.dataTypes;
    }

    public void setDataTypes(TSDataType[] dataTypes) {
        this.dataTypes = dataTypes;
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (String m : this.measurements) {
            ret.add(new Path(this.deviceId, m));
        }
        return ret;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String[] getMeasurements() {
        return this.measurements;
    }

    public void setMeasurements(String[] measurements) {
        this.measurements = measurements;
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsertPlan that = (InsertPlan)o;
        return this.time == that.time && Objects.equals(this.deviceId, that.deviceId) && Arrays.equals(this.measurements, that.measurements) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.time);
    }

    @Override
    public void serializeTo(ByteBuffer buffer) {
        int type = PhysicalPlan.PhysicalPlanType.INSERT.ordinal();
        buffer.put((byte)type);
        buffer.putLong(this.time);
        this.putString(buffer, this.deviceId);
        buffer.putInt(this.measurements.length);
        for (String m : this.measurements) {
            this.putString(buffer, m);
        }
        buffer.putInt(this.values.length);
        for (String m : this.values) {
            this.putString(buffer, m);
        }
    }

    @Override
    public void deserializeFrom(ByteBuffer buffer) {
        this.time = buffer.getLong();
        this.deviceId = this.readString(buffer);
        int measurementSize = buffer.getInt();
        this.measurements = new String[measurementSize];
        for (int i = 0; i < measurementSize; ++i) {
            this.measurements[i] = this.readString(buffer);
        }
        int valueSize = buffer.getInt();
        this.values = new String[valueSize];
        for (int i = 0; i < valueSize; ++i) {
            this.values[i] = this.readString(buffer);
        }
    }

    public String toString() {
        return "deviceId: " + this.deviceId + ", time: " + this.time;
    }
}

