/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.Objects;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicOperatorType;
import org.apache.iotdb.db.qp.logical.crud.FunctionOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IUnaryExpression;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.StringContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicFunctionOperator
extends FunctionOperator {
    protected Path path;
    protected String value;
    private Logger logger = LoggerFactory.getLogger(BasicFunctionOperator.class);
    private BasicOperatorType funcToken;

    public BasicFunctionOperator(int tokenIntType, Path path, String value) throws LogicalOperatorException {
        super(tokenIntType);
        this.operatorType = Operator.OperatorType.BASIC_FUNC;
        this.funcToken = BasicOperatorType.getBasicOpBySymbol(tokenIntType);
        this.path = this.singlePath = path;
        this.value = value;
        this.isLeaf = true;
        this.isSingle = true;
    }

    public String getPath() {
        return this.path.toString();
    }

    public String getValue() {
        return this.value;
    }

    public void setReversedTokenIntType() throws LogicalOperatorException {
        int intType = SQLConstant.reverseWords.get(this.tokenIntType);
        this.setTokenIntType(intType);
        this.funcToken = BasicOperatorType.getBasicOpBySymbol(intType);
    }

    @Override
    public Path getSinglePath() {
        return this.singlePath;
    }

    @Override
    public void setSinglePath(Path singlePath) {
        this.path = this.singlePath = singlePath;
    }

    @Override
    protected Pair<IUnaryExpression, String> transformToSingleQueryFilter(IQueryProcessExecutor executor) throws LogicalOperatorException, PathErrorException {
        IUnaryExpression ret;
        TSDataType type = executor.getSeriesType(this.path);
        if (type == null) {
            throw new PathErrorException("given seriesPath:{" + this.path.getFullPath() + "} don't exist in metadata");
        }
        switch (type) {
            case INT32: {
                ret = this.funcToken.getUnaryExpression(this.path, Integer.valueOf(this.value));
                break;
            }
            case INT64: {
                ret = this.funcToken.getUnaryExpression(this.path, Long.valueOf(this.value));
                break;
            }
            case BOOLEAN: {
                ret = this.funcToken.getUnaryExpression(this.path, Boolean.valueOf(this.value));
                break;
            }
            case FLOAT: {
                ret = this.funcToken.getUnaryExpression(this.path, Float.valueOf(this.value));
                break;
            }
            case DOUBLE: {
                ret = this.funcToken.getUnaryExpression(this.path, Double.valueOf(this.value));
                break;
            }
            case TEXT: {
                ret = this.funcToken.getUnaryExpression(this.path, this.value.startsWith("'") && this.value.endsWith("'") || this.value.startsWith("\"") && this.value.endsWith("\"") ? new Binary(this.value.substring(1, this.value.length() - 1)) : new Binary(this.value));
                break;
            }
            default: {
                throw new LogicalOperatorException("unsupported data type:" + type);
            }
        }
        return new Pair((Object)ret, (Object)this.path.getFullPath());
    }

    @Override
    public String showTree(int spaceNum) {
        StringContainer sc = new StringContainer();
        for (int i = 0; i < spaceNum; ++i) {
            sc.addTail(new String[]{"  "});
        }
        sc.addTail(new String[]{this.path.toString(), this.tokenSymbol, this.value, ", single\n"});
        return sc.toString();
    }

    @Override
    public BasicFunctionOperator clone() {
        BasicFunctionOperator ret;
        try {
            ret = new BasicFunctionOperator(this.tokenIntType, this.path.clone(), this.value);
        }
        catch (LogicalOperatorException e) {
            this.logger.error("error clone:", (Throwable)e);
            return null;
        }
        ret.tokenSymbol = this.tokenSymbol;
        ret.isLeaf = this.isLeaf;
        ret.isSingle = this.isSingle;
        return ret;
    }

    @Override
    public String toString() {
        return "[" + this.path.getFullPath() + this.tokenSymbol + this.value + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasicFunctionOperator that = (BasicFunctionOperator)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.value, that.value) && this.funcToken == that.funcToken;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.path, this.value, this.funcToken});
    }
}

