/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.StartupException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.monitor.IStatistic;
import org.apache.iotdb.db.monitor.MonitorConstants;
import org.apache.iotdb.db.monitor.collector.FileSize;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatMonitor
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StatMonitor.class);
    private final int backLoopPeriod;
    private final int statMonitorDetectFreqSec;
    private final int statMonitorRetainIntervalSec;
    private long runningTimeMillis = System.currentTimeMillis();
    private static final ArrayList<String> temporaryStatList = new ArrayList();
    private final HashMap<String, IStatistic> statisticMap;
    private ScheduledExecutorService service;
    private AtomicLong numBackLoop = new AtomicLong(0L);
    private AtomicLong numInsert = new AtomicLong(0L);
    private AtomicLong numPointsInsert = new AtomicLong(0L);
    private AtomicLong numInsertError = new AtomicLong(0L);

    private StatMonitor() {
        this.initTemporaryStatList();
        MManager mmanager = MManager.getInstance();
        this.statisticMap = new HashMap();
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        this.statMonitorDetectFreqSec = config.getStatMonitorDetectFreqSec();
        this.statMonitorRetainIntervalSec = config.getStatMonitorRetainIntervalSec();
        this.backLoopPeriod = config.getBackLoopPeriodSec();
        if (config.isEnableStatMonitor()) {
            try {
                String prefix = "root.stats";
                if (!mmanager.pathExist(prefix)) {
                    mmanager.setStorageLevelToMTree(prefix);
                }
            }
            catch (MetadataErrorException e) {
                logger.error("MManager cannot set storage level to MTree.", (Throwable)e);
            }
        }
    }

    private void initTemporaryStatList() {
        for (MonitorConstants.FileNodeManagerStatConstants fileNodeManagerStatConstants : MonitorConstants.FileNodeManagerStatConstants.values()) {
            temporaryStatList.add(fileNodeManagerStatConstants.name());
        }
        for (Enum enum_ : MonitorConstants.FileNodeProcessorStatConstants.values()) {
            temporaryStatList.add(enum_.name());
        }
    }

    public static StatMonitor getInstance() {
        return StatMonitorHolder.INSTANCE;
    }

    public static TSRecord convertToTSRecord(Map<String, AtomicLong> hashMap, String statGroupDeltaName, long curTime) {
        TSRecord tsRecord = new TSRecord(curTime, statGroupDeltaName);
        tsRecord.dataPointList = new ArrayList();
        for (Map.Entry<String, AtomicLong> entry : hashMap.entrySet()) {
            AtomicLong value = entry.getValue();
            tsRecord.dataPointList.add(new LongDataPoint(entry.getKey(), value.get()));
        }
        return tsRecord;
    }

    public long getNumPointsInsert() {
        return this.numPointsInsert.get();
    }

    public long getNumInsert() {
        return this.numInsert.get();
    }

    public long getNumInsertError() {
        return this.numInsertError.get();
    }

    void registerStatStorageGroup() {
        MManager mManager = MManager.getInstance();
        String prefix = "root.stats";
        try {
            if (!mManager.pathExist(prefix)) {
                mManager.setStorageLevelToMTree(prefix);
            }
        }
        catch (Exception e) {
            logger.error("MManager cannot set storage level to MTree.", (Throwable)e);
        }
    }

    public synchronized void registerStatStorageGroup(Map<String, String> hashMap) {
        MManager mManager = MManager.getInstance();
        try {
            for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                if (entry.getValue() == null) {
                    logger.error("Registering metadata but data type of {} is null", (Object)entry.getKey());
                }
                if (mManager.pathExist(entry.getKey())) continue;
                mManager.addPathToMTree(new Path(entry.getKey()), TSDataType.valueOf((String)entry.getValue()), TSEncoding.valueOf((String)"RLE"), CompressionType.valueOf((String)TSFileConfig.compressor), Collections.emptyMap());
            }
        }
        catch (MetadataErrorException e) {
            logger.error("Initialize the metadata error.", (Throwable)e);
        }
    }

    public void recovery() {
    }

    void activate() {
        this.service = IoTDBThreadPoolFactory.newScheduledThreadPool(1, ThreadName.STAT_MONITOR.getName());
        this.service.scheduleAtFixedRate(new StatBackLoop(), 1L, this.backLoopPeriod, TimeUnit.SECONDS);
    }

    void clearIStatisticMap() {
        this.statisticMap.clear();
    }

    public long getNumBackLoop() {
        return this.numBackLoop.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStatistics(String path, IStatistic iStatistic) {
        HashMap<String, IStatistic> hashMap = this.statisticMap;
        synchronized (hashMap) {
            logger.debug("Register {} to StatMonitor for statistics service", (Object)path);
            this.statisticMap.put(path, iStatistic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterStatistics(String path) {
        logger.debug("Deregister {} in StatMonitor for stopping statistics service", (Object)path);
        HashMap<String, IStatistic> hashMap = this.statisticMap;
        synchronized (hashMap) {
            if (this.statisticMap.containsKey(path)) {
                this.statisticMap.put(path, null);
            }
        }
    }

    public Map<String, TSRecord> getOneStatisticsValue(String key) {
        String queryPath = key.contains("\\.") ? "root.stats." + key.replaceAll("\\.", "_") : key;
        if (this.statisticMap.containsKey(queryPath)) {
            return this.statisticMap.get(queryPath).getAllStatisticsValue();
        }
        long currentTimeMillis = System.currentTimeMillis();
        HashMap<String, TSRecord> hashMap = new HashMap<String, TSRecord>();
        TSRecord tsRecord = StatMonitor.convertToTSRecord(MonitorConstants.initValues("FILENODE_PROCESSOR_CONST"), queryPath, currentTimeMillis);
        hashMap.put(queryPath, tsRecord);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, TSRecord> gatherStatistics() {
        HashMap<String, IStatistic> hashMap = this.statisticMap;
        synchronized (hashMap) {
            long currentTimeMillis = System.currentTimeMillis();
            HashMap<String, TSRecord> tsRecordHashMap = new HashMap<String, TSRecord>();
            for (Map.Entry<String, IStatistic> entry : this.statisticMap.entrySet()) {
                if (entry.getValue() == null) {
                    switch (entry.getKey()) {
                        case "root.stats.write.global": {
                            tsRecordHashMap.put(entry.getKey(), StatMonitor.convertToTSRecord(MonitorConstants.initValues("FILENODE_PROCESSOR_CONST"), entry.getKey(), currentTimeMillis));
                            break;
                        }
                        case "root.stats.file_size": {
                            tsRecordHashMap.put(entry.getKey(), StatMonitor.convertToTSRecord(MonitorConstants.initValues("FILE_SIZE_CONST"), entry.getKey(), currentTimeMillis));
                            break;
                        }
                    }
                    continue;
                }
                tsRecordHashMap.putAll(entry.getValue().getAllStatisticsValue());
            }
            for (TSRecord value : tsRecordHashMap.values()) {
                value.time = currentTimeMillis;
            }
            return tsRecordHashMap;
        }
    }

    public void close() {
        if (this.service == null || this.service.isShutdown()) {
            return;
        }
        this.statisticMap.clear();
        this.service.shutdown();
        try {
            this.service.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("StatMonitor timing service could not be shutdown.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void start() throws StartupException {
        try {
            if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
                this.activate();
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to start %s because of %s", this.getID().getName(), e.getMessage());
            throw new StartupException(errorMessage);
        }
    }

    @Override
    public void stop() {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableStatMonitor()) {
            this.close();
        }
    }

    @Override
    public ServiceType getID() {
        return ServiceType.STAT_MONITOR_SERVICE;
    }

    class StatBackLoop
    implements Runnable {
        FileSize fileSize = FileSize.getInstance();

        StatBackLoop() {
        }

        @Override
        public void run() {
            try {
                long currentTimeMillis = System.currentTimeMillis();
                long seconds = (currentTimeMillis - StatMonitor.this.runningTimeMillis) / 1000L;
                if (seconds >= (long)StatMonitor.this.statMonitorDetectFreqSec) {
                    StatMonitor.this.runningTimeMillis = currentTimeMillis;
                    this.cleanOutDated();
                }
                Map<String, TSRecord> tsRecordHashMap = StatMonitor.this.gatherStatistics();
                this.insert(tsRecordHashMap);
                StatMonitor.this.numBackLoop.incrementAndGet();
            }
            catch (Exception e) {
                logger.error("Error occurred in Stat Monitor thread", (Throwable)e);
            }
        }

        public void cleanOutDated() {
            long currentTimeMillis = System.currentTimeMillis();
            try {
                StorageEngine fManager = StorageEngine.getInstance();
                for (Map.Entry entry : StatMonitor.this.statisticMap.entrySet()) {
                    for (String statParamName : ((IStatistic)entry.getValue()).getStatParamsHashMap().keySet()) {
                        if (!temporaryStatList.contains(statParamName)) continue;
                        fManager.delete((String)entry.getKey(), statParamName, currentTimeMillis - (long)(StatMonitor.this.statMonitorRetainIntervalSec * 1000));
                    }
                }
            }
            catch (StorageEngineException e) {
                logger.error("Error occurred when deleting statistics information periodically, because", (Throwable)e);
            }
        }

        public void insert(Map<String, TSRecord> tsRecordHashMap) {
            StorageEngine fManager = StorageEngine.getInstance();
            for (Map.Entry<String, TSRecord> entry : tsRecordHashMap.entrySet()) {
                try {
                    fManager.insert(new InsertPlan(entry.getValue()));
                    StatMonitor.this.numInsert.incrementAndGet();
                    int pointNum = entry.getValue().dataPointList.size();
                    StatMonitor.this.numPointsInsert.addAndGet(pointNum);
                }
                catch (StorageEngineException e) {
                    StatMonitor.this.numInsertError.incrementAndGet();
                    logger.error("Inserting stat points error.", (Throwable)e);
                }
            }
        }
    }

    private static class StatMonitorHolder {
        private static final StatMonitor INSTANCE = new StatMonitor();

        private StatMonitorHolder() {
        }
    }
}

