/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.iotdb.db.exception.PathErrorException;

public class PNode
implements Serializable {
    private static final long serialVersionUID = -7166236304286006338L;
    private String name;
    private PNode parent;
    private HashMap<String, PNode> children;
    private boolean isLeaf;
    private LinkedHashMap<String, Integer> linkedMTreePathMap;

    public PNode(String name, PNode parent, boolean isLeaf) {
        this.name = name;
        this.parent = parent;
        this.isLeaf = isLeaf;
        if (!isLeaf) {
            this.setChildren(new HashMap<String, PNode>());
        } else {
            this.linkedMTreePathMap = new LinkedHashMap();
        }
    }

    public void linkMPath(String mTreePath) throws PathErrorException {
        if (!this.isLeaf) {
            throw new PathErrorException("Current PNode is NOT leaf node");
        }
        if (!this.linkedMTreePathMap.containsKey(mTreePath)) {
            this.linkedMTreePathMap.put(mTreePath, 1);
        }
    }

    public void unlinkMPath(String mTreePath) throws PathErrorException {
        if (!this.isLeaf) {
            throw new PathErrorException("Current PNode is NOT leaf node");
        }
        if (!this.linkedMTreePathMap.containsKey(mTreePath)) {
            return;
        }
        this.linkedMTreePathMap.remove(mTreePath);
    }

    public boolean hasChild(String key) {
        return this.getChildren().containsKey(key);
    }

    public PNode getChild(String key) {
        return this.getChildren().get(key);
    }

    public void addChild(String name, PNode node) {
        this.getChildren().put(name, node);
    }

    public void deleteChild(String name) {
        this.getChildren().remove(name);
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PNode getParent() {
        return this.parent;
    }

    public void setParent(PNode parent) {
        this.parent = parent;
    }

    public HashMap<String, PNode> getChildren() {
        return this.children;
    }

    public void setChildren(HashMap<String, PNode> children) {
        this.children = children;
    }

    public HashMap<String, Integer> getLinkedMTreePathMap() {
        return this.linkedMTreePathMap;
    }

    public void setLinkedMTreePathMap(LinkedHashMap<String, Integer> linkedMTreePathMap) {
        this.linkedMTreePathMap = linkedMTreePathMap;
    }
}

