/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class MNode
implements Serializable {
    private static final long serialVersionUID = -770028375899514063L;
    private String name;
    private boolean isLeaf;
    private boolean isStorageLevel;
    private Map<String, MeasurementSchema> schemaMap;
    private Map<String, Integer> numSchemaMap;
    private String dataFileName;
    private MeasurementSchema schema;
    private MNode parent;
    private Map<String, MNode> children;

    public MNode(String name, MNode parent, boolean isLeaf) {
        this.setName(name);
        this.parent = parent;
        this.isLeaf = isLeaf;
        this.isStorageLevel = false;
        if (!isLeaf) {
            this.children = new LinkedHashMap<String, MNode>();
        }
    }

    public MNode(String name, MNode parent, TSDataType dataType, TSEncoding encoding, CompressionType type) {
        this(name, parent, true);
        this.schema = new MeasurementSchema(name, dataType, encoding, type);
    }

    public boolean isStorageLevel() {
        return this.isStorageLevel;
    }

    public void setStorageLevel(boolean b) {
        this.isStorageLevel = b;
        if (b) {
            this.schemaMap = new HashMap<String, MeasurementSchema>();
            this.numSchemaMap = new HashMap<String, Integer>();
        } else {
            this.numSchemaMap = null;
            this.schemaMap = null;
        }
    }

    public Map<String, MeasurementSchema> getSchemaMap() {
        return this.schemaMap;
    }

    public Map<String, Integer> getNumSchemaMap() {
        return this.numSchemaMap;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public boolean hasChild(String key) {
        if (!this.isLeaf) {
            return this.children.containsKey(key);
        }
        return false;
    }

    public void addChild(String key, MNode child) {
        if (!this.isLeaf) {
            this.children.put(key, child);
        }
    }

    public void deleteChild(String key) {
        this.children.remove(key);
    }

    public MNode getChild(String key) {
        if (!this.isLeaf) {
            return this.children.get(key);
        }
        return null;
    }

    public int getLeafCount() {
        if (this.isLeaf) {
            return 1;
        }
        int leafCount = 0;
        for (MNode child : this.children.values()) {
            leafCount += child.getLeafCount();
        }
        return leafCount;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public void setDataFileName(String dataFileName) {
        this.dataFileName = dataFileName;
    }

    public String toString() {
        return this.getName();
    }

    public MeasurementSchema getSchema() {
        return this.schema;
    }

    public void setSchema(MeasurementSchema schema) {
        this.schema = schema;
    }

    public MNode getParent() {
        return this.parent;
    }

    public void setParent(MNode parent) {
        this.parent = parent;
    }

    public Map<String, MNode> getChildren() {
        return this.children;
    }

    public void setChildren(Map<String, MNode> children) {
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

