/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.pool;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.concurrent.ThreadName;
import org.apache.iotdb.db.exception.ProcessorException;

public class FlushSubTaskPoolManager {
    private static final int EXIT_WAIT_TIME = 60000;
    private ExecutorService pool = IoTDBThreadPoolFactory.newCachedThreadPool(ThreadName.FLUSH_SUB_TASK_SERVICE.getName());

    private FlushSubTaskPoolManager() {
    }

    public static FlushSubTaskPoolManager getInstance() {
        return InstanceHolder.instance;
    }

    public void close(boolean block, long timeout) throws ProcessorException {
        this.pool.shutdown();
        if (block) {
            try {
                if (!this.pool.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                    throw new ProcessorException("Flush thread pool doesn't exit after 60000 ms");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ProcessorException("Interrupted while waiting flush thread pool to exit. ", e);
            }
        }
    }

    public synchronized Future<?> submit(Runnable task) {
        return this.pool.submit(task);
    }

    public synchronized <T> Future<T> submit(Callable<T> task) {
        return this.pool.submit(task);
    }

    public int getActiveCnt() {
        return ((ThreadPoolExecutor)this.pool).getActiveCount();
    }

    public int getWaitingTasksNumber() {
        return ((ThreadPoolExecutor)this.pool).getQueue().size();
    }

    public int getCorePoolSize() {
        return ((ThreadPoolExecutor)this.pool).getCorePoolSize();
    }

    private static class InstanceHolder {
        private static FlushSubTaskPoolManager instance = new FlushSubTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

