/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.tsfile.write.chunk.ChunkBuffer;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkBufferPool {
    private static final Logger logger = LoggerFactory.getLogger(ChunkBufferPool.class);
    private static final Deque<ChunkBuffer> availableChunkBuffer = new ArrayDeque<ChunkBuffer>();
    private long size = 0L;
    private static final int WAIT_TIME = 2000;

    private ChunkBufferPool() {
    }

    public ChunkBuffer getEmptyChunkBuffer(Object applier, MeasurementSchema schema) {
        if (!IoTDBDescriptor.getInstance().getConfig().isChunkBufferPoolEnable()) {
            return new ChunkBuffer(schema);
        }
        Deque<ChunkBuffer> deque = availableChunkBuffer;
        synchronized (deque) {
            long capacity = 2L * MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * (long)IoTDBDescriptor.getInstance().getConfig().getMaxMemtableNumber() + 100000L;
            if (availableChunkBuffer.isEmpty() && this.size < capacity) {
                ++this.size;
                return new ChunkBuffer(schema);
            }
            if (!availableChunkBuffer.isEmpty()) {
                ChunkBuffer chunkBuffer = availableChunkBuffer.pop();
                chunkBuffer.reInit(schema);
                return chunkBuffer;
            }
            int waitCount = 1;
            while (true) {
                if (!availableChunkBuffer.isEmpty()) {
                    return availableChunkBuffer.pop();
                }
                try {
                    availableChunkBuffer.wait(2000L);
                }
                catch (InterruptedException e) {
                    logger.error("{} fails to wait fot ReusableChunkBuffer {}, continue to wait", applier, (Object)e);
                    Thread.currentThread().interrupt();
                }
                logger.info("{} has waited for a ReusableChunkBuffer for {}ms", applier, (Object)(waitCount++ * 2000));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBack(ChunkBuffer chunkBuffer) {
        if (!IoTDBDescriptor.getInstance().getConfig().isChunkBufferPoolEnable()) {
            return;
        }
        Deque<ChunkBuffer> deque = availableChunkBuffer;
        synchronized (deque) {
            chunkBuffer.reset();
            long capacity = MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups() * (long)IoTDBDescriptor.getInstance().getConfig().getMaxMemtableNumber();
            if (this.size > capacity) {
                --this.size;
            } else {
                availableChunkBuffer.push(chunkBuffer);
            }
            availableChunkBuffer.notify();
        }
    }

    public static ChunkBufferPool getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static class InstanceHolder {
        private static final ChunkBufferPool INSTANCE = new ChunkBufferPool();

        private InstanceHolder() {
        }
    }
}

