/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageEngineFailureException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IService;
import org.apache.iotdb.db.service.ServiceType;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEngine
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StorageEngine.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String systemDir;
    private final ConcurrentHashMap<String, StorageGroupProcessor> processorMap = new ConcurrentHashMap();
    private static final StorageEngine INSTANCE = new StorageEngine();

    public static StorageEngine getInstance() {
        return INSTANCE;
    }

    private StorageEngine() {
        this.systemDir = FilePathUtils.regularizePath(config.getSystemDir()) + "storage_groups";
        try {
            FileUtils.forceMkdir((File)new File(this.systemDir));
        }
        catch (IOException e) {
            throw new StorageEngineFailureException("create system directory failed!");
        }
        try {
            List<String> storageGroups = MManager.getInstance().getAllStorageGroupNames();
            for (String storageGroup : storageGroups) {
                StorageGroupProcessor processor = new StorageGroupProcessor(this.systemDir, storageGroup);
                logger.info("Storage Group Processor {} is recovered successfully", (Object)storageGroup);
                this.processorMap.put(storageGroup, processor);
            }
        }
        catch (MetadataErrorException | ProcessorException e) {
            logger.error("init a storage group processor failed. ", (Throwable)e);
            throw new StorageEngineFailureException(e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.syncCloseAllProcessor();
    }

    @Override
    public ServiceType getID() {
        return ServiceType.STORAGE_ENGINE_SERVICE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageGroupProcessor getProcessor(String path) throws StorageEngineException {
        String storageGroupName = "";
        try {
            storageGroupName = MManager.getInstance().getStorageGroupNameByPath(path);
            StorageGroupProcessor processor = this.processorMap.get(storageGroupName);
            if (processor == null) {
                String string = storageGroupName = storageGroupName.intern();
                synchronized (string) {
                    processor = this.processorMap.get(storageGroupName);
                    if (processor == null) {
                        logger.debug("construct a processor instance, the storage group is {}, Thread is {}", (Object)storageGroupName, (Object)Thread.currentThread().getId());
                        processor = new StorageGroupProcessor(this.systemDir, storageGroupName);
                        this.processorMap.put(storageGroupName, processor);
                    }
                }
            }
            return processor;
        }
        catch (PathErrorException | ProcessorException e) {
            logger.error("Fail to get StorageGroupProcessor {}", (Object)storageGroupName, (Object)e);
            throw new StorageEngineException(e);
        }
    }

    public synchronized void reset() {
        this.processorMap.clear();
    }

    public boolean insert(InsertPlan insertPlan) throws StorageEngineException {
        StorageGroupProcessor storageGroupProcessor;
        try {
            storageGroupProcessor = this.getProcessor(insertPlan.getDeviceId());
        }
        catch (Exception e) {
            logger.warn("get StorageGroupProcessor of device {} failed, because {}", new Object[]{insertPlan.getDeviceId(), e.getMessage(), e});
            throw new StorageEngineException(e);
        }
        return storageGroupProcessor.insert(insertPlan);
    }

    public void asyncFlushAndSealAllFiles() {
        for (StorageGroupProcessor storageGroupProcessor : this.processorMap.values()) {
            storageGroupProcessor.putAllWorkingTsFileProcessorIntoClosingList();
        }
    }

    public void syncCloseAllProcessor() {
        logger.info("Start closing all storage group processor");
        for (StorageGroupProcessor processor : this.processorMap.values()) {
            processor.waitForAllCurrentTsFileProcessorsClosed();
        }
    }

    public void update(String deviceId, String measurementId, long startTime, long endTime, TSDataType type, String v) {
    }

    public void delete(String deviceId, String measurementId, long timestamp) throws StorageEngineException {
        StorageGroupProcessor storageGroupProcessor = this.getProcessor(deviceId);
        try {
            storageGroupProcessor.delete(deviceId, measurementId, timestamp);
        }
        catch (IOException e) {
            throw new StorageEngineException(e);
        }
    }

    public int beginQuery(String deviceId) throws StorageEngineException {
        return -1;
    }

    public void endQuery(String deviceId, int token) throws StorageEngineException {
    }

    public QueryDataSource query(SingleSeriesExpression seriesExpression, QueryContext context) throws StorageEngineException {
        String deviceId = seriesExpression.getSeriesPath().getDevice();
        String measurementId = seriesExpression.getSeriesPath().getMeasurement();
        StorageGroupProcessor storageGroupProcessor = this.getProcessor(deviceId);
        return storageGroupProcessor.query(deviceId, measurementId, context);
    }

    public boolean appendFileToStorageGroupProcessor(String storageGroupName, TsFileResource appendFile, String appendFilePath) throws StorageEngineException {
        return true;
    }

    public List<String> getOverlapFiles(String storageGroupName, TsFileResource appendFile, String uuid) throws StorageEngineException {
        return Collections.emptyList();
    }

    public void mergeAll() throws StorageEngineException {
    }

    public void deleteAllDataFilesInOneStorageGroup(String storageGroupName) {
        if (this.processorMap.containsKey(storageGroupName)) {
            this.syncDeleteDataFiles(storageGroupName);
        }
    }

    private void syncDeleteDataFiles(String storageGroupName) {
        logger.info("Force to delete the data in storage group processor {}", (Object)storageGroupName);
        StorageGroupProcessor processor = this.processorMap.get(storageGroupName);
        processor.syncDeleteDataFiles();
    }

    public void addTimeSeries(Path path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws StorageEngineException {
        StorageGroupProcessor storageGroupProcessor = this.getProcessor(path.getDevice());
        storageGroupProcessor.addMeasurement(path.getMeasurement(), dataType, encoding, compressor, props);
    }

    public synchronized boolean deleteAll() {
        logger.info("Start deleting all storage groups' timeseries");
        try {
            for (String storageGroup : MManager.getInstance().getAllStorageGroupNames()) {
                this.deleteAllDataFilesInOneStorageGroup(storageGroup);
            }
        }
        catch (MetadataErrorException e) {
            logger.error("delete storage groups failed.", (Throwable)e);
            return false;
        }
        return true;
    }
}

