/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    public static final String CONFIG_NAME = "iotdb-engine.properties";
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private String rpcAddress = "0.0.0.0";
    private int rpcPort = 6667;
    private long allocateMemoryForWrite = Runtime.getRuntime().maxMemory() * 6L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private boolean enableParameterAdapter = true;
    private boolean enableWal = true;
    private volatile boolean readOnly = false;
    private int flushWalThreshold = 10000;
    private long forceWalPeriodInMs = 10L;
    private int walBufferSize = 0x1000000;
    private String baseDir = "data";
    private String systemDir = "data/system";
    private String[] dataDirs = new String[]{"data/data"};
    private String multiDirStrategyClassName = null;
    private String walFolder = "data/wal";
    private String indexFileDir = "data/index";
    private int maxMemtableNumber = 20;
    private int mergeConcurrentThreads = Runtime.getRuntime().availableProcessors();
    private int fetchSize = 10000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private ZoneId zoneID = ZoneId.systemDefault();
    private long tsFileSizeThreshold = 0x20000000L;
    private long memtableSizeThreshold = 0x8000000L;
    private int backLoopPeriodSec = 5;
    private boolean enableStatMonitor = false;
    private int statMonitorDetectFreqSec = 600;
    private int statMonitorRetainIntervalSec = 600;
    private int mManagerCacheSize = 400000;
    private boolean isSyncEnable = true;
    private int syncServerPort = 5555;
    private String languageVersion = "EN";
    private boolean updateHistoricalDataPossibility = false;
    private String ipWhiteList = "0.0.0.0/0";
    private long cacheFileReaderClearPeriod = 100000L;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private boolean enablePerformanceStat = false;
    private long performanceStatDisplayInterval = 60000L;
    private int performanceStatMemoryInKB = 20;
    private boolean chunkBufferPoolEnable = false;

    public ZoneId getZoneID() {
        return this.zoneID;
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        int i;
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(this.baseDir);
        dirs.add(this.systemDir);
        dirs.add(this.walFolder);
        dirs.add(this.indexFileDir);
        dirs.addAll(Arrays.asList(this.dataDirs));
        String homeDir = System.getProperty("IOTDB_HOME", null);
        for (i = 0; i < dirs.size(); ++i) {
            String dir = (String)dirs.get(i);
            if (new File(dir).isAbsolute() || homeDir == null || homeDir.length() <= 0) continue;
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
            dirs.set(i, dir);
        }
        this.baseDir = (String)dirs.get(0);
        this.systemDir = (String)dirs.get(1);
        this.walFolder = (String)dirs.get(2);
        this.indexFileDir = (String)dirs.get(3);
        for (i = 0; i < this.dataDirs.length; ++i) {
            this.dataDirs[i] = (String)dirs.get(i + 4);
        }
    }

    private void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public boolean isEnableWal() {
        return this.enableWal;
    }

    public void setEnableWal(boolean enableWal) {
        this.enableWal = enableWal;
    }

    public int getFlushWalThreshold() {
        return this.flushWalThreshold;
    }

    public void setFlushWalThreshold(int flushWalThreshold) {
        this.flushWalThreshold = flushWalThreshold;
    }

    public long getForceWalPeriodInMs() {
        return this.forceWalPeriodInMs;
    }

    public void setForceWalPeriodInMs(long forceWalPeriodInMs) {
        this.forceWalPeriodInMs = forceWalPeriodInMs;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getWalFolder() {
        return this.walFolder;
    }

    void setWalFolder(String walFolder) {
        this.walFolder = walFolder;
    }

    void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public String getIndexFileDir() {
        return this.indexFileDir;
    }

    private void setIndexFileDir(String indexFileDir) {
        this.indexFileDir = indexFileDir;
    }

    public int getMergeConcurrentThreads() {
        return this.mergeConcurrentThreads;
    }

    void setMergeConcurrentThreads(int mergeConcurrentThreads) {
        this.mergeConcurrentThreads = mergeConcurrentThreads;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    void setZoneID(ZoneId zoneID) {
        this.zoneID = zoneID;
    }

    public long getTsFileSizeThreshold() {
        return this.tsFileSizeThreshold;
    }

    public void setTsFileSizeThreshold(long tsFileSizeThreshold) {
        this.tsFileSizeThreshold = tsFileSizeThreshold;
    }

    public int getBackLoopPeriodSec() {
        return this.backLoopPeriodSec;
    }

    void setBackLoopPeriodSec(int backLoopPeriodSec) {
        this.backLoopPeriodSec = backLoopPeriodSec;
    }

    public boolean isEnableStatMonitor() {
        return this.enableStatMonitor;
    }

    public void setEnableStatMonitor(boolean enableStatMonitor) {
        this.enableStatMonitor = enableStatMonitor;
    }

    public int getStatMonitorDetectFreqSec() {
        return this.statMonitorDetectFreqSec;
    }

    void setStatMonitorDetectFreqSec(int statMonitorDetectFreqSec) {
        this.statMonitorDetectFreqSec = statMonitorDetectFreqSec;
    }

    public int getStatMonitorRetainIntervalSec() {
        return this.statMonitorRetainIntervalSec;
    }

    void setStatMonitorRetainIntervalSec(int statMonitorRetainIntervalSec) {
        this.statMonitorRetainIntervalSec = statMonitorRetainIntervalSec;
    }

    public int getmManagerCacheSize() {
        return this.mManagerCacheSize;
    }

    void setmManagerCacheSize(int mManagerCacheSize) {
        this.mManagerCacheSize = mManagerCacheSize;
    }

    public boolean isSyncEnable() {
        return this.isSyncEnable;
    }

    void setSyncEnable(boolean syncEnable) {
        this.isSyncEnable = syncEnable;
    }

    public int getSyncServerPort() {
        return this.syncServerPort;
    }

    void setSyncServerPort(int syncServerPort) {
        this.syncServerPort = syncServerPort;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public boolean isUpdateHistoricalDataPossibility() {
        return this.updateHistoricalDataPossibility;
    }

    void setUpdateHistoricalDataPossibility(boolean updateHistoricalDataPossibility) {
        this.updateHistoricalDataPossibility = updateHistoricalDataPossibility;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public boolean isEnableParameterAdapter() {
        return this.enableParameterAdapter;
    }

    public void setEnableParameterAdapter(boolean enableParameterAdapter) {
        this.enableParameterAdapter = enableParameterAdapter;
    }

    public long getAllocateMemoryForWrite() {
        return this.allocateMemoryForWrite;
    }

    public void setAllocateMemoryForWrite(long allocateMemoryForWrite) {
        this.allocateMemoryForWrite = allocateMemoryForWrite;
    }

    public long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    public void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public boolean isEnablePerformanceStat() {
        return this.enablePerformanceStat;
    }

    public void setEnablePerformanceStat(boolean enablePerformanceStat) {
        this.enablePerformanceStat = enablePerformanceStat;
    }

    public long getPerformanceStatDisplayInterval() {
        return this.performanceStatDisplayInterval;
    }

    public void setPerformanceStatDisplayInterval(long performanceStatDisplayInterval) {
        this.performanceStatDisplayInterval = performanceStatDisplayInterval;
    }

    public int getPerformanceStatMemoryInKB() {
        return this.performanceStatMemoryInKB;
    }

    public void setPerformanceStatMemoryInKB(int performanceStatMemoryInKB) {
        this.performanceStatMemoryInKB = performanceStatMemoryInKB;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }
}

