/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.jdbc.IoTDBResultMetadata;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.Utils;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSOperationHandle;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBQueryResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBQueryResultSet.class);
    private static final String METHOD_NOT_SUPPORTED = "Method not supported";
    private final String TIMESTAMP_STR = "Time";
    private static final String limitStr = "LIMIT";
    private static final String offsetStr = "OFFSET";
    private Statement statement = null;
    private String sql;
    private SQLWarning warningChain = null;
    private boolean wasNull = false;
    private boolean isClosed = false;
    private TSIService.Iface client = null;
    private TSOperationHandle operationHandle = null;
    private List<String> columnInfoList;
    private List<String> columnTypeList;
    private Map<String, Integer> columnInfoMap;
    private RowRecord record;
    private Iterator<RowRecord> recordItr;
    private int rowsFetched = 0;
    private int maxRows;
    private int fetchSize;
    private boolean emptyResultSet = false;
    private String operationType;
    private int rowsLimit = 0;
    private int rowsOffset = 0;
    private long queryId;
    private boolean ignoreTimeStamp = false;
    private int maxRowsOrRowsLimit;

    public IoTDBQueryResultSet() {
    }

    public IoTDBQueryResultSet(Statement statement, List<String> columnName, TSIService.Iface client, TSOperationHandle operationHandle, String sql, String aggregations, List<String> columnTypeList, long queryId) throws SQLException {
        this.statement = statement;
        this.maxRows = statement.getMaxRows();
        this.fetchSize = statement.getFetchSize();
        this.client = client;
        this.operationHandle = operationHandle;
        this.sql = sql;
        this.operationType = aggregations;
        this.columnTypeList = columnTypeList;
        this.columnInfoList = new ArrayList<String>();
        this.columnInfoList.add("Time");
        this.columnInfoMap = new HashMap<String, Integer>();
        this.columnInfoMap.put("Time", 1);
        this.queryId = queryId;
        int index = 2;
        for (String name : columnName) {
            this.columnInfoList.add(name);
            if (this.columnInfoMap.containsKey(name)) continue;
            this.columnInfoMap.put(name, index++);
        }
        this.maxRowsOrRowsLimit = this.maxRows;
        String[] splited = sql.toUpperCase().split("\\s+");
        List<String> arraySplited = Arrays.asList(splited);
        try {
            int posLimit = arraySplited.indexOf(limitStr);
            if (posLimit != -1) {
                this.rowsLimit = Integer.parseInt(splited[posLimit + 1]);
                this.maxRowsOrRowsLimit = this.maxRows == 0 ? this.rowsLimit : (this.rowsLimit < this.maxRows ? this.rowsLimit : this.maxRows);
                int posOffset = arraySplited.indexOf(offsetStr);
                if (posOffset != -1) {
                    this.rowsOffset = Integer.parseInt(splited[posOffset + 1]);
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IoTDBSQLException("Out of range: LIMIT&SLIMIT parameter should be Int32.");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeOperationHandle();
        this.client = null;
        this.isClosed = true;
    }

    private void closeOperationHandle() throws SQLException {
        try {
            if (this.operationHandle != null) {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.operationHandle, this.queryId);
                TSCloseOperationResp closeResp = this.client.closeOperation(closeReq);
                Utils.verifySuccess(closeResp.getStatus());
            }
        }
        catch (SQLException e) {
            throw new SQLException("Error occurs for close opeation in server side becasuse " + e);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when connecting to server for close operation, becasue: " + (Object)((Object)e));
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.columnInfoMap.get(columnName);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return new BigDecimal(this.getValueByName(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        MathContext mc = new MathContext(scale);
        return this.getBigDecimal(columnIndex).round(mc);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        String b = this.getValueByName(columnName);
        if (b == null) {
            throw new SQLException(String.format("The value got by %s (column name) is NULL.", columnName));
        }
        if ("0".equalsIgnoreCase(b.trim())) {
            return false;
        }
        if ("1".equalsIgnoreCase(b.trim())) {
            return true;
        }
        return Boolean.parseBoolean(b);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return 0;
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return new byte[0];
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return new byte[0];
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return new Date(this.getLong(columnIndex));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return Double.parseDouble(this.getValueByName(columnName));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return Float.parseFloat(this.getValueByName(columnName));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return Integer.parseInt(this.getValueByName(columnName));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return Long.parseLong(this.getValueByName(columnName));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new IoTDBResultMetadata(this.columnInfoList, this.operationType, this.columnTypeList);
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getValueByName(columnName);
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public <T> T getObject(int arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public <T> T getObject(String arg0, Class<T> arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return Short.parseShort(this.getValueByName(columnName));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.findColumnNameByIndex(columnIndex));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getValueByName(columnName);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return new Time(this.getLong(columnIndex));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return new Timestamp(this.getLong(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    private boolean nextWithoutConstraints() throws SQLException {
        if (!(this.recordItr != null && this.recordItr.hasNext() || this.emptyResultSet)) {
            TSFetchResultsReq req = new TSFetchResultsReq(this.sql, this.fetchSize, this.queryId);
            try {
                TSFetchResultsResp resp = this.client.fetchResults(req);
                Utils.verifySuccess(resp.getStatus());
                if (!resp.hasResultSet) {
                    this.emptyResultSet = true;
                } else {
                    TSQueryDataSet tsQueryDataSet = resp.getQueryDataSet();
                    List<RowRecord> records = Utils.convertRowRecords(tsQueryDataSet);
                    this.recordItr = records.iterator();
                }
            }
            catch (TException e) {
                throw new SQLException("Cannot fetch result from server, because of network connection: {} ", e);
            }
        }
        if (this.emptyResultSet) {
            return false;
        }
        this.record = this.recordItr.next();
        return true;
    }

    @Override
    public boolean next() throws SQLException {
        boolean isNext;
        if (this.maxRowsOrRowsLimit > 0 && this.rowsFetched >= this.maxRowsOrRowsLimit) {
            if (this.rowsLimit == 0 || this.maxRows > 0 && this.maxRows < this.rowsLimit) {
                logger.debug("Reach max rows " + this.maxRows);
            }
            return false;
        }
        if (this.rowsOffset != 0) {
            for (int i = 0; i < this.rowsOffset; ++i) {
                if (this.nextWithoutConstraints()) continue;
                return false;
            }
            this.rowsOffset = 0;
        }
        if (isNext = this.nextWithoutConstraints()) {
            ++this.rowsFetched;
        }
        return isNext;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private void checkRecord() throws SQLException {
        if (this.record == null) {
            throw new SQLException("No record remains");
        }
    }

    private String findColumnNameByIndex(int columnIndex) throws SQLException {
        if (columnIndex <= 0) {
            throw new SQLException("column index should start from 1");
        }
        if (columnIndex > this.columnInfoList.size()) {
            throw new SQLException(String.format("column index %d out of range %d", columnIndex, this.columnInfoList.size()));
        }
        return this.columnInfoList.get(columnIndex - 1);
    }

    private String getValueByName(String columnName) throws SQLException {
        this.checkRecord();
        if (columnName.equals("Time")) {
            return String.valueOf(this.record.getTimestamp());
        }
        int tmp = this.columnInfoMap.get(columnName);
        int i = 0;
        for (Field field : this.record.getFields()) {
            if (++i != tmp - 1) continue;
            return field.isNull() ? null : field.getStringValue();
        }
        return null;
    }

    public boolean isIgnoreTimeStamp() {
        return this.ignoreTimeStamp;
    }

    public void setIgnoreTimeStamp(boolean ignoreTimeStamp) {
        this.ignoreTimeStamp = ignoreTimeStamp;
    }
}

