/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.jdbc.IoTDBMetadataResultMetadata;
import org.apache.iotdb.jdbc.IoTDBQueryResultSet;

public class IoTDBMetadataResultSet
extends IoTDBQueryResultSet {
    public static final String GET_STRING_COLUMN = "COLUMN";
    public static final String GET_STRING_STORAGE_GROUP = "STORAGE_GROUP";
    public static final String GET_STRING_TIMESERIES_NAME = "Timeseries";
    public static final String GET_STRING_TIMESERIES_STORAGE_GROUP = "Storage Group";
    public static final String GET_STRING_TIMESERIES_DATATYPE = "DataType";
    public static final String GET_STRING_TIMESERIES_ENCODING = "Encoding";
    private Iterator<?> columnItr;
    private MetadataType type;
    private String currentColumn;
    private String currentStorageGroup;
    private List<String> currentTimeseries;
    private int colCount;
    private String[] showLabels;
    private static final String METHOD_NOT_SUPPORTED = "Method not supported";

    public IoTDBMetadataResultSet(List<String> columns, Set<String> storageGroupSet, List<List<String>> showTimeseriesList) throws SQLException {
        if (columns != null) {
            this.type = MetadataType.COLUMN;
            this.colCount = 1;
            this.showLabels = new String[]{"Column"};
            this.columnItr = columns.iterator();
        } else if (storageGroupSet != null) {
            this.type = MetadataType.STORAGE_GROUP;
            this.colCount = 1;
            this.showLabels = new String[]{GET_STRING_TIMESERIES_STORAGE_GROUP};
            this.columnItr = storageGroupSet.iterator();
        } else if (showTimeseriesList != null) {
            this.type = MetadataType.TIMESERIES;
            this.colCount = 4;
            this.showLabels = new String[]{GET_STRING_TIMESERIES_NAME, GET_STRING_TIMESERIES_STORAGE_GROUP, GET_STRING_TIMESERIES_DATATYPE, GET_STRING_TIMESERIES_ENCODING};
            this.columnItr = showTimeseriesList.iterator();
        } else {
            throw new SQLException("TsfileMetadataResultSet constructor is wrongly used.");
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new IoTDBMetadataResultMetadata(this.showLabels);
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.columnItr.hasNext();
        if (hasNext) {
            if (this.type == MetadataType.STORAGE_GROUP) {
                this.currentStorageGroup = (String)this.columnItr.next();
            } else if (this.type == MetadataType.COLUMN) {
                this.currentColumn = (String)this.columnItr.next();
            } else {
                this.currentTimeseries = (List)this.columnItr.next();
            }
        }
        return hasNext;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        switch (this.type) {
            case STORAGE_GROUP: {
                if (columnIndex != 1) break;
                return this.getString(GET_STRING_STORAGE_GROUP);
            }
            case TIMESERIES: {
                if (columnIndex < 1 || columnIndex > this.colCount) break;
                return this.getString(this.showLabels[columnIndex - 1]);
            }
            case COLUMN: {
                if (columnIndex != 1) break;
                return this.getString(GET_STRING_COLUMN);
            }
        }
        throw new SQLException(String.format("select column index %d does not exists", columnIndex));
    }

    @Override
    public String getString(String columnName) throws SQLException {
        switch (columnName) {
            case "STORAGE_GROUP": {
                return this.currentStorageGroup;
            }
            case "Timeseries": {
                return this.currentTimeseries.get(0);
            }
            case "Storage Group": {
                return this.currentTimeseries.get(1);
            }
            case "DataType": {
                return this.currentTimeseries.get(2);
            }
            case "Encoding": {
                return this.currentTimeseries.get(3);
            }
            case "COLUMN": {
                return this.currentColumn;
            }
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public int getType() throws SQLException {
        return this.type.ordinal();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new SQLException(METHOD_NOT_SUPPORTED);
    }

    public static enum MetadataType {
        STORAGE_GROUP,
        TIMESERIES,
        COLUMN;

    }
}

