/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.time.ZoneId;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.iotdb.jdbc.Config;
import org.apache.iotdb.jdbc.IoTDBConnectionParams;
import org.apache.iotdb.jdbc.IoTDBDatabaseMetadata;
import org.apache.iotdb.jdbc.IoTDBPreparedInsertionStatement;
import org.apache.iotdb.jdbc.IoTDBPreparedStatement;
import org.apache.iotdb.jdbc.IoTDBSQLException;
import org.apache.iotdb.jdbc.IoTDBStatement;
import org.apache.iotdb.jdbc.IoTDBURLException;
import org.apache.iotdb.jdbc.Utils;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConnection
implements Connection {
    Logger logger = LoggerFactory.getLogger(IoTDBConnection.class);
    private final List<TSProtocolVersion> supportedProtocols = new LinkedList<TSProtocolVersion>();
    public TSIService.Iface client = null;
    public TS_SessionHandle sessionHandle = null;
    private IoTDBConnectionParams params;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSocket transport;
    private TSProtocolVersion protocol;
    private ZoneId zoneId;
    private boolean autoCommit;

    public IoTDBConnection() {
    }

    public IoTDBConnection(String url, Properties info) throws SQLException, TTransportException {
        if (url == null) {
            throw new IoTDBURLException("Input url cannot be null");
        }
        this.params = Utils.parseUrl(url, info);
        this.supportedProtocols.add(TSProtocolVersion.TSFILE_SERVICE_PROTOCOL_V1);
        this.openTransport();
        this.client = new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport));
        this.openSession();
        this.client = IoTDBConnection.newSynchronizedClient(this.client);
        this.autoCommit = false;
    }

    public static TSIService.Iface newSynchronizedClient(TSIService.Iface client) {
        return (TSIService.Iface)Proxy.newProxyInstance(IoTDBConnection.class.getClassLoader(), new Class[]{TSIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionHandle);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when closing session at server. Maybe server is down.", e);
        }
        finally {
            this.isClosed = true;
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new IoTDBStatement(this, this.client, this.sessionHandle, this.zoneId);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException(String.format("Statements with result set concurrency %d are not supported", resultSetConcurrency));
        }
        if (resultSetType == 1005) {
            throw new SQLException(String.format("Statements with resultset type %d are not supported", resultSetType));
        }
        return new IoTDBStatement(this, this.client, this.sessionHandle, this.zoneId);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        this.autoCommit = arg0;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "no cata log";
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new IoTDBDatabaseMetadata(this, this.client);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return Config.connectionTimeoutInMs;
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (sql.equalsIgnoreCase("INSERT")) {
            return new IoTDBPreparedInsertionStatement(this, this.client, this.sessionHandle, this.zoneId);
        }
        return new IoTDBPreparedStatement(this, this.client, this.sessionHandle, sql, this.zoneId);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    private void openTransport() throws TTransportException {
        this.transport = new TSocket(this.params.getHost(), this.params.getPort(), Config.connectionTimeoutInMs);
        try {
            this.transport.getSocket().setKeepAlive(true);
        }
        catch (SocketException e) {
            this.logger.error("Cannot set socket keep alive because: ", (Throwable)e);
        }
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
    }

    private void openSession() throws SQLException {
        TSOpenSessionReq openReq = new TSOpenSessionReq(TSProtocolVersion.TSFILE_SERVICE_PROTOCOL_V1);
        openReq.setUsername(this.params.getUsername());
        openReq.setPassword(this.params.getPassword());
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            try {
                Utils.verifySuccess(openResp.getStatus());
            }
            catch (IoTDBSQLException e) {
                this.transport.close();
                throw e;
            }
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported TsFile protocol");
            }
            this.setProtocol(openResp.getServerProtocolVersion());
            this.sessionHandle = openResp.getSessionHandle();
            if (this.zoneId != null) {
                this.setTimeZone(this.zoneId.toString());
            } else {
                this.zoneId = ZoneId.of(this.getTimeZone());
            }
        }
        catch (TException e) {
            throw new SQLException(String.format("Can not establish connection with %s.", this.params.getJdbcUriString()), e);
        }
        this.isClosed = false;
    }

    public boolean reconnect() {
        boolean flag = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.transport == null) continue;
                this.transport.close();
                this.openTransport();
                this.client = new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport));
                this.openSession();
                this.client = IoTDBConnection.newSynchronizedClient(this.client);
                flag = true;
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    this.logger.error("reconnect is interrupted.", (Throwable)e1);
                }
            }
        }
        return flag;
    }

    public String getTimeZone() throws TException, IoTDBSQLException {
        if (this.zoneId != null) {
            return this.zoneId.toString();
        }
        TSGetTimeZoneResp resp = this.client.getTimeZone();
        Utils.verifySuccess(resp.getStatus());
        return resp.getTimeZone();
    }

    public void setTimeZone(String zoneId) throws TException, IoTDBSQLException {
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(zoneId);
        TSSetTimeZoneResp resp = this.client.setTimeZone(req);
        Utils.verifySuccess(resp.getStatus());
        this.zoneId = ZoneId.of(zoneId);
    }

    public ServerProperties getServerProperties() throws TException {
        return this.client.getProperties();
    }

    public TSProtocolVersion getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TSProtocolVersion protocol) {
        this.protocol = protocol;
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TSIService.Iface client;

        SynchronizedHandler(TSIService.Iface client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                TSIService.Iface iface = this.client;
                synchronized (iface) {
                    return method.invoke((Object)this.client, args);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
        }
    }
}

