<!--

    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.

-->

# IoTDB-Grafana

* [中文](https://github.com/apache/incubator-iotdb/blob/master/grafana/readme_zh.md)

This project provides a connector which reads data from iotdb and sends to grafana(https://grafana.com/). Before you use this tool, make sure grafana and iotdb are correctly installed and started.

## Grafana installation

Download url: https://grafana.com/grafana/download
version >= 4.4.1

### Install data source plugin
plugin name: simple-json-datasource
Download url: https://github.com/grafana/simple-json-datasource

After downloading this plugin, you can use the grafana-cli tool to install SimpleJson from the commandline:
> grafana-cli plugins install grafana-simple-json-datasource

Alternatively, you can manually download the .zip file and unpack it into your grafana plugins directory.

* `{grafana-install-directory}\data\plugin\` (Windows)
* `/var/lib/grafana/plugins` (Linux)

### Start Grafana
Grafana will auto start after installing, or you can run `sudo service grafana-server start`

## IoTDB installation

See https://github.com/apache/incubator-iotdb

## IoTDB-Grafana installation

```shell
git clone https://github.com/apache/incubator-iotdb.git
mvn clean package -pl grafana -am -Dmaven.test.skip=true
cd grafana
```

Copy `application.properties` from `conf/` directory to `target` directory.(Or just make sure that `application.properties` and `iotdb-grafana-{version}.war` are in the same directory.)

Edit `application.properties`
```
# ip and port of IoTDB 
spring.datasource.url = jdbc:iotdb://127.0.0.1:6667/
spring.datasource.username = root
spring.datasource.password = root
spring.datasource.driver-class-name=org.apache.iotdb.jdbc.IoTDBDriver
server.port = 8888
```

### Start IoTDB-Grafana

```shell
cd grafana/target/
java -jar iotdb-grafana-{version}.war
```

If you see the following output, iotdb-grafana connector is successfully activated.

```shell
$ java -jar iotdb-grafana-{version}.war

  .   ____          _            __ _ _
 /\\ / ___'_ __ _ _(_)_ __  __ _ \ \ \ \
( ( )\___ | '_ | '_| | '_ \/ _` | \ \ \ \
 \\/  ___)| |_)| | | | | || (_| |  ) ) ) )
  '  |____| .__|_| |_|_| |_\__, | / / / /
 =========|_|==============|___/=/_/_/_/
 :: Spring Boot ::        (v1.5.4.RELEASE)
...
```

## Explore in Grafana

The default port of Grafana is 3000, see http://localhost:3000

Username and password are both "admin".

### Add data source

Select `Data Sources` and  then `Add data source`, select `SimpleJson` in `Type` and `URL` is http://localhost:8888
![](./img/add_data_source.png)
![](./img/edit_data_source.png)

### Design in dashboard

Add diagrams in dashboard and customize your query. See http://docs.grafana.org/guides/getting_started/

![](./img/add_graph.png)


