<!--
    Licensed to the Apache Software Foundation (ASF) under one
    or more contributor license agreements.  See the NOTICE file
    distributed with this work for additional information
    regarding copyright ownership.  The ASF licenses this file
    to you under the Apache License, Version 2.0 (the
    "License"); you may not use this file except in compliance
    with the License.  You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, either express or implied.  See the License for the
    specific language governing permissions and limitations
    under the License.
-->

[![Build Status](https://travis-ci.org/apache/incubator-datasketches-java.svg?branch=master)](https://travis-ci.org/apache/incubator-datasketches-java)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/org.apache.datasketches/datasketches-java/badge.svg)](https://maven-badges.herokuapp.com/maven-central/org.apache.datasketches/datasketches-java)
[![Language grade: Java](https://img.shields.io/lgtm/grade/java/g/apache/incubator-datasketches-java.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/apache/incubator-datasketches-java/context:java)
[![Total alerts](https://img.shields.io/lgtm/alerts/g/apache/incubator-datasketches-java.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/apache/incubator-datasketches-java/alerts/)
[![Coverage Status](https://coveralls.io/repos/github/apache/incubator-datasketches-java/badge.svg?branch=master&service=github)](https://coveralls.io/github/apache/incubator-datasketches-java?branch=master)


=================


# DataSketches Core Java Component
This is the core Java component of the DataSketches library.  It contains all of the sketching algorithms and can be accessed directly from user applications. 
This component is also is a dependency of other components of the library that create adaptors for target systems, such as Hadoop Pig and Hadoop Hive.
Please refer to our [website](https://datasketches.github.io) for more comprehensive information about the various sketching algorithms and how to use them.

Note that we have a parallel core component for C++ and Python implementations of the same sketch algorithms, 
[incubator-datasketches-cpp](https://github.com/apache/incubator-datasketches-cpp).


## [DataSketches Library Website](https://datasketches.github.io/)

## [Latest Release](https://github.com/apache/incubator-datasketches-java/releases)

## [Forum](https://groups.google.com/forum/#!forum/sketches-user)

## Note: This package can only be compiled using Java 1.8.
