/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil

import org.junit.Test

import org.apache.daffodil.Implicits._
import org.apache.daffodil.exceptions._
import java.io.FileNotFoundException
import junit.framework.Assert._

class TestImplicits {

  @Test
  def testIntercept1() {
    intercept[Abort] {
      Assert.abort("yadda")
    }
  }

  @Test
  def testIntercept2() {
    val e = intercept[InterceptFailedException] {
      intercept[Abort] {
        // this will not cause an abort exception
        2 + 2
      }
    }
    assertTrue(e.getMessage().contains("Failed to intercept"))
  }

  @Test
  def testIntercept3() {
    val e = intercept[InterceptFailedException] {
      intercept[FileNotFoundException] {
        // an exception is caught, but not the right kind
        throw new Exception("yadda")
      }
    }
    assertTrue(e.getMessage().contains("Expected 'java.io.FileNotFoundException'"))
  }

}

