/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

addSbtPlugin("com.typesafe.sbt" % "sbt-native-packager" % "1.3.6")

addSbtPlugin("org.musigma" % "sbt-rat" % "0.6.0")

// Both sbt and the sbt-native-pacakger plugin have transitive dependencies to
// different versions of plexus-utils and guava, but with different major
// version numbers. SBT interprets this major version number difference as
// having dependencies that are potentially not binary compatible, resulting in
// a warning message when starting SBT. It appears the binary incompatibilities
// (if they exist) do not affect building Daffodil, so this overrides the
// dependencies to the latest versions and removes the warning.
dependencyOverrides ++= Seq(
  "org.codehaus.plexus" % "plexus-utils" % "3.0.17",
  "com.google.guava" % "guava" % "20.0"
)
