/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.section12.length_properties

import org.junit.Test
import org.apache.daffodil.tdml.Runner
import org.junit.AfterClass

object TestLengthPropertiesDebug {
  val testDir_01 = "/org/apache/daffodil/ibm-tests/"
  val testDir_02 = "/org/apache/daffodil/section12/length_properties/"

  val runner_01 = Runner(testDir_01, "dpaext1.tdml")
  val runner_02 = Runner(testDir_02, "LengthProperties.tdml")

  @AfterClass def shutDown {
    runner_01.reset
    runner_02.reset
  }

}

class TestLengthPropertiesDebug {

  import TestLengthPropertiesDebug._

  // uses lengthUnits bytes with lengthKind explicit and utf-8
  @Test def test_length_explicit_12_01() { runner_01.runOneTest("length_explicit_12_01") }

  // DFDL-931 Uses lengthUnits bytes with utf-8 encoding and explicit lengthKind
  @Test def test_LengthProp_02() { runner_02.runOneTest("LengthProp_02") }
  @Test def test_LengthProp_charVsBytes() { runner_02.runOneTest("LengthProp_charVsBytes") }
  @Test def test_LengthProp_charVsBytes2() { runner_02.runOneTest("LengthProp_charVsBytes2") }
  @Test def test_LengthProp_longByteLength() { runner_02.runOneTest("LengthProp_longByteLength") }

  // should just skip the 2 excess bytes
  @Test def test_LengthProp_06() { runner_02.runOneTest("LengthProp_06") }

  //DFDL-460
  @Test def test_LengthProp_floatBits() { runner_02.runOneTest("LengthProp_floatBits") }

}
