/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.section07.defineFormat

import org.junit.Test
import org.apache.daffodil.tdml.Runner
import org.junit.AfterClass

object defineFormatTestsDebug {
  val testDir = "/org/apache/daffodil/section07/defineFormat/"
  val runner = Runner(testDir, "defineFormat.tdml")

  @AfterClass def tearDown() {
    runner.reset
  }

}

class defineFormatTestsDebug {

  import defineFormatTestsDebug._

  //DFDL-1276
  @Test def test_format_with_comment() { runner.runOneTest("format_with_comment") }

  //DFDL-478
  @Test def test_nameCollision() { runner.runOneTest("nameCollision") }

}
