/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.daffodil.dsom

import org.apache.daffodil.util.SchemaUtils
import org.junit.Test
import org.apache.daffodil.util.TestUtils

class TestMiddleEndAttributes2 {

  @Test def testNestedSequencePrefixSep() = {
    // LoggingDefaults.setLoggingLevel(LogLevel.Debug)
    val testSchema = SchemaUtils.dfdlTestSchema(

      <dfdl:format ref="tns:GeneralFormat" lengthKind="delimited" encoding="US-ASCII"/>,

      <xs:element name="e1">
        <xs:complexType>
          <xs:sequence dfdl:separator="/" dfdl:separatorPosition="prefix">
            <xs:sequence>
              <xs:element name="x" type="xs:int"/>
            </xs:sequence>
          </xs:sequence>
        </xs:complexType>
      </xs:element>)

    val sset = new SchemaSet(testSchema)
    val Seq(sch) = sset.schemas
    val Seq(sd, _) = sch.schemaDocuments

    // Explore global element decl
    val Seq(e1f) = sd.globalElementDecls
    val e1 = e1f.forRoot()
    val e1ct = e1.complexType
    val seq1 = e1ct.sequence
    val mems = seq1.groupMembers
    val Seq(t1: Term) = mems
    t1.asInstanceOf[Sequence]
    val (_, actual) = TestUtils.testString(testSchema, "/5")
    val expected = <e1><x>5</x></e1>
    TestUtils.assertEqualsXMLElements(expected, actual)
  }

}
