/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory.mv.io;

import java.util.function.Consumer;
import org.apache.ignite3.internal.pagememory.io.IoVersions;
import org.apache.ignite3.internal.pagememory.io.PageIo;
import org.apache.ignite3.internal.pagememory.tree.BplusTree;
import org.apache.ignite3.internal.pagememory.tree.io.BplusIo;
import org.apache.ignite3.internal.pagememory.tree.io.BplusLeafIo;
import org.apache.ignite3.internal.pagememory.util.PageIdUtils;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChain;
import org.apache.ignite3.internal.storage.pagememory.mv.VersionChainKey;
import org.apache.ignite3.internal.storage.pagememory.mv.io.VersionChainIo;

public final class VersionChainLeafIo
extends BplusLeafIo<VersionChainKey>
implements VersionChainIo {
    public static final IoVersions<VersionChainLeafIo> VERSIONS = new IoVersions((PageIo[])new VersionChainLeafIo[]{new VersionChainLeafIo(1)});

    private VersionChainLeafIo(int ver) {
        super(11, ver, 50);
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BplusIo<VersionChainKey> srcIo, long srcPageAddr, int srcIdx) {
        VersionChainIo.super.store(dstPageAddr, dstIdx, srcIo, srcPageAddr, srcIdx);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, VersionChainKey row) {
        VersionChainIo.super.storeByOffset(pageAddr, off, row);
    }

    @Override
    public VersionChainKey getLookupRow(BplusTree<VersionChainKey, ?> tree, long pageAddr, int idx) {
        return this.getRow(pageAddr, idx, VersionChainLeafIo.getPartitionId(pageAddr));
    }

    @Override
    public void visit(BplusTree<VersionChainKey, ?> tree, long pageAddr, Consumer<VersionChainKey> c) {
        int partitionId = VersionChainLeafIo.getPartitionId(pageAddr);
        int count = this.getCount(pageAddr);
        for (int i = 0; i < count; ++i) {
            VersionChain chain = this.getRow(pageAddr, i, partitionId);
            c.accept(chain);
        }
    }

    private static int getPartitionId(long pageAddr) {
        long pageId = VersionChainLeafIo.getPageId(pageAddr);
        return PageIdUtils.partitionId(pageId);
    }
}

