/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.NodeWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;

@FunctionalInterface
public interface PartitionProvider<RowT> {
    public List<PartitionWithConsistencyToken> getPartitions(ExecutionContext<RowT> var1);

    public static <RowT> PartitionProvider<RowT> fromPartitions(List<PartitionWithConsistencyToken> partitions) {
        return ctx -> partitions;
    }

    public static List<PartitionWithConsistencyToken> partitionsForNode(Int2ObjectMap<NodeWithConsistencyToken> assignments, String nodeName) {
        ArrayList<PartitionWithConsistencyToken> result = new ArrayList<PartitionWithConsistencyToken>();
        for (int i = 0; i < assignments.size(); ++i) {
            NodeWithConsistencyToken a = (NodeWithConsistencyToken)assignments.get(i);
            if (!a.name().equals(nodeName)) continue;
            result.add(new PartitionWithConsistencyToken(i, a.enlistmentConsistencyToken()));
        }
        return result;
    }
}

