/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.handlers;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.network.ClusterNodeResolver;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.TxRecoveryEngine;
import org.apache.ignite3.internal.tx.TransactionMeta;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.TxStateMeta;
import org.apache.ignite3.internal.tx.TxStateMetaFinishing;
import org.apache.ignite3.internal.tx.message.TxStateCommitPartitionRequest;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.jetbrains.annotations.Nullable;

public class TxStateCommitPartitionReplicaRequestHandler {
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final TxManager txManager;
    private final ClusterNodeResolver clusterNodeResolver;
    private final InternalClusterNode localNode;
    private final TxRecoveryEngine txRecoveryEngine;

    public TxStateCommitPartitionReplicaRequestHandler(TxStatePartitionStorage txStatePartitionStorage, TxManager txManager, ClusterNodeResolver clusterNodeResolver, InternalClusterNode localNode, TxRecoveryEngine txRecoveryEngine) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.txManager = txManager;
        this.clusterNodeResolver = clusterNodeResolver;
        this.localNode = localNode;
        this.txRecoveryEngine = txRecoveryEngine;
    }

    public CompletableFuture<TransactionMeta> handle(TxStateCommitPartitionRequest request) {
        UUID txId = request.txId();
        TxStateMeta txMeta = this.txManager.stateMeta(txId);
        if (txMeta != null && txMeta.txState() == TxState.FINISHING) {
            assert (txMeta instanceof TxStateMetaFinishing) : txMeta;
            return ((TxStateMetaFinishing)txMeta).txFinishFuture();
        }
        if (txMeta == null || !TxState.isFinalState(txMeta.txState())) {
            return this.triggerTxRecoveryOnTxStateResolutionIfNeeded(txId, txMeta);
        }
        return CompletableFuture.completedFuture(txMeta);
    }

    private CompletableFuture<TransactionMeta> triggerTxRecoveryOnTxStateResolutionIfNeeded(UUID txId, @Nullable TxStateMeta txStateMeta) {
        assert (txStateMeta == null || txStateMeta.txState() == TxState.PENDING || txStateMeta.txState() == TxState.ABANDONED) : "Unexpected transaction state: " + txStateMeta;
        TxMeta txMeta = this.txStatePartitionStorage.get(txId);
        if (txMeta == null) {
            if (txStateMeta == null || txStateMeta.txState() == TxState.ABANDONED || txStateMeta.txCoordinatorId() == null || this.clusterNodeResolver.getById(txStateMeta.txCoordinatorId()) == null) {
                return ((CompletableFuture)this.txRecoveryEngine.triggerTxRecovery(txId, this.localNode.id()).handle((T v, U ex) -> CompletableFuture.completedFuture(this.txManager.stateMeta(txId)))).thenCompose(v -> v);
            }
            assert (txStateMeta != null && txStateMeta.txState() == TxState.PENDING) : "Unexpected transaction state: " + txStateMeta;
            return CompletableFuture.completedFuture(txStateMeta);
        }
        assert (TxState.isFinalState(txMeta.txState())) : "Unexpected transaction state: " + txMeta;
        return CompletableFuture.completedFuture(txMeta);
    }
}

