/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.io.Serializable;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.GridSpinReadWriteLock;
import org.apache.ignite.lang.IgniteFuture;

public class ConnectGateway
implements Serializable {
    private static final long serialVersionUID = 8798048262450037107L;
    private GridSpinReadWriteLock lock = new GridSpinReadWriteLock();
    private IgniteException err;

    public void enter() {
        this.lock.readLock();
        if (this.err != null) {
            this.lock.readUnlock();
            throw this.err;
        }
    }

    public boolean tryEnter() {
        boolean res;
        this.lock.readLock();
        boolean bl = res = this.err == null;
        if (!res) {
            this.lock.readUnlock();
        }
        return res;
    }

    public void leave() {
        this.lock.readUnlock();
    }

    public void disconnected(IgniteFuture<?> reconnectFut) {
        this.lock.writeLock();
        this.err = new IgniteClientDisconnectedException(reconnectFut, "Failed to connect, client node disconnected.");
        this.lock.writeUnlock();
    }

    public void reconnected() {
        this.lock.writeLock();
        try {
            if (this.err instanceof IgniteClientDisconnectedException) {
                this.err = null;
            }
        }
        finally {
            this.lock.writeUnlock();
        }
    }

    public void stopped() {
        this.lock.readLock();
        this.err = new IgniteException("Failed to connect, node stopped.");
        this.lock.readUnlock();
    }
}

