/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class ReentrantReadWriteLockWithTracking
implements ReadWriteLock {
    public static final String LOCK_HOLD_MESSAGE = "ReadLock held the lock more than ";
    private long readLockThreshold;
    private final ReentrantReadWriteLock delegate = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock.ReadLock readLock;
    private ReentrantReadWriteLock.WriteLock writeLock = new ReentrantReadWriteLock.WriteLock(this.delegate){};

    public ReentrantReadWriteLockWithTracking(IgniteLogger log, long readLockThreshold) {
        this.readLock = new ReadLockWithTracking(this.delegate, log, readLockThreshold);
        this.readLockThreshold = readLockThreshold;
    }

    public ReentrantReadWriteLockWithTracking() {
        this.readLock = new ReentrantReadWriteLock.ReadLock(this.delegate){};
    }

    @Override
    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.readLock;
    }

    @Override
    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.writeLock;
    }

    public long lockWaitThreshold() {
        return this.readLockThreshold;
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.delegate.isWriteLockedByCurrentThread();
    }

    public int getReadHoldCount() {
        return this.delegate.getReadHoldCount();
    }

    public int getReadLockCount() {
        return this.delegate.getReadLockCount();
    }

    public static class ReadLockWithTracking
    extends ReentrantReadWriteLock.ReadLock {
        private static final long serialVersionUID = 0L;
        private static final ThreadLocal<T2<Integer, Long>> READ_LOCK_HOLDER_TS = ThreadLocal.withInitial(() -> new T2<Integer, Long>(0, 0L));
        private IgniteLogger log;
        private long readLockThreshold;

        protected ReadLockWithTracking(ReentrantReadWriteLock lock, @Nullable IgniteLogger log, long readLockThreshold) {
            super(lock);
            this.log = log;
            this.readLockThreshold = readLockThreshold;
        }

        private void inc() {
            T2<Integer, Long> val = READ_LOCK_HOLDER_TS.get();
            int cntr = (Integer)val.get1();
            if (cntr == 0) {
                val.set2(U.currentTimeMillis());
            }
            val.set1(++cntr);
            READ_LOCK_HOLDER_TS.set(val);
        }

        private void dec() {
            long timeout;
            T2<Integer, Long> val = READ_LOCK_HOLDER_TS.get();
            int cntr = (Integer)val.get1();
            if (--cntr == 0 && (timeout = U.currentTimeMillis() - (Long)val.get2()) > this.readLockThreshold) {
                GridStringBuilder sb = new GridStringBuilder();
                sb.a(ReentrantReadWriteLockWithTracking.LOCK_HOLD_MESSAGE + timeout + " ms." + IgniteUtils.nl());
                U.printStackTrace(Thread.currentThread().getId(), sb);
                U.warn(this.log, sb.toString());
            }
            val.set1(cntr);
            READ_LOCK_HOLDER_TS.set(val);
        }

        @Override
        public void lock() {
            super.lock();
            this.inc();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            super.lockInterruptibly();
            this.inc();
        }

        @Override
        public boolean tryLock() {
            if (super.tryLock()) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            if (super.tryLock(timeout, unit)) {
                this.inc();
                return true;
            }
            return false;
        }

        @Override
        public void unlock() {
            super.unlock();
            this.dec();
        }
    }
}

